/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Parser;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.ConvertedChanger;
import ch.njol.skript.classes.DefaultChangers;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.SimpleLiteral;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class BukkitClasses {
    static {
        Skript.registerClass(new ClassInfo<TreeType>(TreeType.class, "treetype").user("tree type", "tree ?types?", "trees?").defaultExpression(new SimpleLiteral<TreeType>(TreeType.TREE, true)).parser(new Parser<TreeType>(){

            @Override
            public TreeType parse(String s) {
                if ((s = s.toLowerCase(Locale.ENGLISH)).endsWith(" tree")) {
                    s = s.substring(0, s.length() - " tree".length());
                }
                if (s.equals("regular")) {
                    return TreeType.TREE;
                }
                if (s.equals("normal")) {
                    return TreeType.TREE;
                }
                if (s.equals("big")) {
                    return TreeType.BIG_TREE;
                }
                if (s.equals("fir")) {
                    return TreeType.REDWOOD;
                }
                if (s.equals("tall fir")) {
                    return TreeType.TALL_REDWOOD;
                }
                if (s.equals("big fir")) {
                    return TreeType.TALL_REDWOOD;
                }
                if (s.equals("big redwood")) {
                    return TreeType.TALL_REDWOOD;
                }
                try {
                    return TreeType.valueOf((String)s.toUpperCase(Locale.ENGLISH).replace(' ', '_'));
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }

            @Override
            public String toString(TreeType o) {
                return o.toString().toLowerCase().replace('_', ' ');
            }
        }).serializer(new EnumSerializer<TreeType>(TreeType.class)));
        Skript.registerClass(new ClassInfo<Entity>(Entity.class, "entity").defaultExpression(new EventValueExpression<Entity>(Entity.class)).parser(new Parser<Entity>(){

            @Override
            public Entity parse(String s) {
                return null;
            }

            @Override
            public String toString(Entity e) {
                return EntityType.toString(e);
            }
        }));
        Skript.registerClass(new ClassInfo<LivingEntity>(LivingEntity.class, "livingentity").defaultExpression(new EventValueExpression<LivingEntity>(LivingEntity.class)));
        Skript.registerClass(new ClassInfo<Block>(Block.class, "block").defaultExpression(new EventValueExpression<Block>(Block.class)).parser(new Parser<Block>(){

            @Override
            public Block parse(String s) {
                return null;
            }

            @Override
            public String toString(Block b) {
                return ItemType.toString(new ItemStack(b.getTypeId(), 1, (short)b.getState().getRawData()));
            }

            @Override
            public String getDebugMessage(Block b) {
                return String.valueOf(this.toString(b)) + " block (" + b.getWorld().getName() + "|" + b.getX() + "/" + b.getY() + "/" + b.getZ() + ")";
            }
        }).changer(new Changer<Block, Object>(){

            @Override
            public Class<?> acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.SET) {
                    return ItemType.class;
                }
                return ItemType[].class;
            }

            public void change(Block[] blocks, Object delta, Changer.ChangeMode mode) {
                Block[] blockArray = blocks;
                int n = blocks.length;
                int n2 = 0;
                while (n2 < n) {
                    Block block = blockArray[n2];
                    switch (mode) {
                        case SET: {
                            ((ItemType)delta).setBlock(block, true);
                            break;
                        }
                        case CLEAR: {
                            block.setTypeId(0, true);
                            break;
                        }
                        case ADD: 
                        case REMOVE: {
                            ItemType type;
                            int n3;
                            int n4;
                            ItemType[] itemTypeArray;
                            BlockState state = block.getState();
                            if (!(state instanceof InventoryHolder)) break;
                            if (mode == Changer.ChangeMode.ADD) {
                                itemTypeArray = (ItemType[])delta;
                                n4 = itemTypeArray.length;
                                n3 = 0;
                                while (n3 < n4) {
                                    type = itemTypeArray[n3];
                                    type.addTo(((InventoryHolder)state).getInventory());
                                    ++n3;
                                }
                            } else {
                                itemTypeArray = (ItemType[])delta;
                                n4 = itemTypeArray.length;
                                n3 = 0;
                                while (n3 < n4) {
                                    type = itemTypeArray[n3];
                                    type.removeFrom(((InventoryHolder)state).getInventory());
                                    ++n3;
                                }
                            }
                            state.update();
                        }
                    }
                    ++n2;
                }
            }
        }).serializer(new Serializer<Block>(){

            @Override
            public String serialize(Block b) {
                return String.valueOf(b.getWorld().getName()) + ":" + b.getX() + "," + b.getY() + "," + b.getZ();
            }

            @Override
            public Block deserialize(String s) {
                String[] split = s.split("[:,]");
                if (split.length != 4) {
                    return null;
                }
                World w = Bukkit.getWorld((String)split[0]);
                if (w == null) {
                    return null;
                }
                try {
                    int[] l = new int[3];
                    int i = 0;
                    while (i < 3) {
                        l[i] = Integer.parseInt(split[i + 1]);
                        ++i;
                    }
                    return w.getBlockAt(l[0], l[1], l[2]);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Location>(Location.class, "location").defaultExpression(new EventValueExpression<Location>(Location.class)).parser(new Parser<Location>(){

            @Override
            public Location parse(String s) {
                return null;
            }

            @Override
            public String toString(Location l) {
                return "x: " + StringUtils.toString(l.getX(), 2) + ", y: " + StringUtils.toString(l.getY(), 2) + ", z: " + StringUtils.toString(l.getZ(), 2);
            }

            @Override
            public String getDebugMessage(Location l) {
                return "(" + l.getWorld().getName() + "|" + l.getX() + "/" + l.getY() + "/" + l.getZ() + "|yaw=" + l.getYaw() + "/pitch=" + l.getPitch() + ")";
            }
        }).serializer(new Serializer<Location>(){

            @Override
            public String serialize(Location l) {
                return String.valueOf(l.getWorld().getName()) + ":" + l.getX() + "," + l.getY() + "," + l.getZ() + "|" + l.getYaw() + "/" + l.getPitch();
            }

            @Override
            public Location deserialize(String s) {
                String[] split = s.split("[:,|/]");
                if (split.length != 6) {
                    return null;
                }
                World w = Bukkit.getWorld((String)split[0]);
                if (w == null) {
                    return null;
                }
                try {
                    double[] l = new double[5];
                    int i = 0;
                    while (i < 5) {
                        l[i] = Double.parseDouble(split[i + 1]);
                        ++i;
                    }
                    return new Location(w, l[0], l[1], l[2], (float)l[3], (float)l[4]);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<World>(World.class, "world").user("world", "worlds?").defaultExpression(new EventValueExpression<World>(World.class)).parser(new Parser<World>(){

            @Override
            public World parse(String s) {
                if (!s.matches("\".+\"")) {
                    return null;
                }
                if (s.matches("(?i)^\"world .+")) {
                    return Bukkit.getWorld((String)s.substring("\"world ".length(), s.length() - 1));
                }
                return Bukkit.getWorld((String)s.substring(1, s.length() - 1));
            }

            @Override
            public String toString(World w) {
                return w.getName();
            }
        }).serializer(new Serializer<World>(){

            @Override
            public String serialize(World w) {
                return w.getName();
            }

            @Override
            public World deserialize(String s) {
                return Bukkit.getWorld((String)s);
            }
        }), "string");
        Skript.registerClass(new ClassInfo<Inventory>(Inventory.class, "inventory").defaultExpression(new EventValueExpression<Inventory>(Inventory.class)).parser(new Parser<Inventory>(){

            @Override
            public Inventory parse(String s) {
                return null;
            }

            @Override
            public String toString(Inventory i) {
                return "inventory of " + Skript.toString(i.getHolder());
            }

            @Override
            public String getDebugMessage(Inventory i) {
                return "inventory of " + Skript.getDebugMessage(i.getHolder());
            }
        }).changer(DefaultChangers.inventoryChanger));
        Skript.registerClass(new ClassInfo<Player>(Player.class, "player").user("player", "players?").defaultExpression(new EventValueExpression<Player>(Player.class)).parser(new Parser<Player>(){

            @Override
            public Player parse(String s) {
                if (Skript.isLoading()) {
                    return null;
                }
                List ps = Bukkit.matchPlayer((String)s);
                if (ps.size() == 1) {
                    return (Player)ps.get(0);
                }
                return null;
            }

            @Override
            public String toString(Player p) {
                return p.getDisplayName();
            }

            @Override
            public String getDebugMessage(Player p) {
                return String.valueOf(p.getName()) + " " + Skript.getDebugMessage(p.getLocation());
            }
        }).changer(new ConvertedChanger<Player, ItemType[]>(Skript.getConverter(Player.class, Inventory.class), Inventory.class, DefaultChangers.inventoryChanger)).serializeAs(OfflinePlayer.class));
        Skript.registerClass(new ClassInfo<OfflinePlayer>(OfflinePlayer.class, "offlineplayer").user("player", new String[0]).defaultExpression(new EventValueExpression<OfflinePlayer>(OfflinePlayer.class)).parser(new Parser<OfflinePlayer>(){

            @Override
            public OfflinePlayer parse(String s) {
                return null;
            }

            @Override
            public String toString(OfflinePlayer p) {
                return p.getName();
            }

            @Override
            public String getDebugMessage(OfflinePlayer p) {
                if (p.isOnline()) {
                    return Skript.getDebugMessage(p.getPlayer());
                }
                return p.getName();
            }
        }).serializer(new Serializer<OfflinePlayer>(){

            @Override
            public String serialize(OfflinePlayer p) {
                return p.getName();
            }

            @Override
            public OfflinePlayer deserialize(String s) {
                return Bukkit.getOfflinePlayer((String)s);
            }
        }));
        Skript.registerClass(new ClassInfo<CommandSender>(CommandSender.class, "commandsender").user("player/console", new String[0]).defaultExpression(new EventValueExpression<CommandSender>(CommandSender.class)).parser(new Parser<CommandSender>(){

            @Override
            public CommandSender parse(String s) {
                if (s.equalsIgnoreCase("console") || s.equalsIgnoreCase("server")) {
                    return Bukkit.getConsoleSender();
                }
                return null;
            }

            @Override
            public String toString(CommandSender s) {
                if (s instanceof Player) {
                    return ((Player)s).getDisplayName();
                }
                return s.getName();
            }

            @Override
            public String getDebugMessage(CommandSender s) {
                if (s instanceof Player) {
                    return null;
                }
                return s.getName();
            }
        }));
        Skript.registerClass(new ClassInfo<BlockFace>(BlockFace.class, "blockface").user("direction", "directions?").parser(new Parser<BlockFace>(){

            @Override
            public BlockFace parse(String s) {
                return Utils.getBlockFace(s, true);
            }

            @Override
            public String toString(BlockFace o) {
                return o.toString().toLowerCase(Locale.ENGLISH).replace('_', ' ');
            }
        }));
        Skript.registerClass(new ClassInfo<InventoryHolder>(InventoryHolder.class, "inventoryholder").defaultExpression(new EventValueExpression<InventoryHolder>(InventoryHolder.class)));
        Skript.registerClass(new ClassInfo<GameMode>(GameMode.class, "gamemode").user("game mode", "game ?modes?").defaultExpression(new SimpleLiteral<GameMode>(GameMode.SURVIVAL, true)).parser(new Parser<GameMode>(){

            @Override
            public GameMode parse(String s) {
                try {
                    return GameMode.valueOf((String)s.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }

            @Override
            public String toString(GameMode m) {
                return m.toString().toLowerCase();
            }
        }).serializer(null));
        Skript.registerClass(new ClassInfo<ItemStack>(ItemStack.class, "itemstack").user("material", "item", "material").parser(new Parser<ItemStack>(){

            @Override
            public ItemStack parse(String s) {
                ItemType t = Aliases.parseItemType(s);
                if (t == null) {
                    return null;
                }
                if ((t = t.getItem()).numTypes() != 1) {
                    Skript.error("'" + s + "' represents multiple materials");
                    return null;
                }
                if (!t.getTypes().get(0).hasDataRange()) {
                    return t.getRandom();
                }
                if (t.getTypes().get((int)0).dataMin > 0) {
                    Skript.error("'" + s + "' represents multiple materials");
                    return null;
                }
                ItemStack i = t.getRandom();
                i.setDurability((short)0);
                return i;
            }

            @Override
            public String toString(ItemStack i) {
                return ItemType.toString(i);
            }
        }).serializer(new Serializer<ItemStack>(){

            @Override
            public String serialize(ItemStack i) {
                StringBuilder b = new StringBuilder();
                b.append(i.getType().name());
                b.append(":" + i.getDurability());
                b.append("*" + i.getAmount());
                for (Map.Entry e : i.getEnchantments().entrySet()) {
                    b.append("#" + ((Enchantment)e.getKey()).getId());
                    b.append(":" + e.getValue());
                }
                return b.toString();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ItemStack deserialize(String s) {
                String[] split = s.split("[:*#]");
                if (split.length < 3 || split.length % 2 != 1) {
                    return null;
                }
                try {
                    ItemStack is = new ItemStack(Material.valueOf((String)split[0]), Integer.parseInt(split[2]), Short.parseShort(split[1]));
                    int i = 3;
                    while (true) {
                        if (i >= split.length) {
                            return is;
                        }
                        Enchantment ench = Enchantment.getById((int)Integer.parseInt(split[i]));
                        if (ench == null) {
                            return null;
                        }
                        is.addUnsafeEnchantment(ench, Integer.parseInt(split[i + 1]));
                        i += 2;
                    }
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
    }
}

