/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.api;

import java.lang.reflect.Array;
import java.util.Arrays;

public interface Converter<F, T> {
    public T convert(F var1);

    public static final class ConverterInfo<F, T> {
        public Class<F> from;
        public Class<T> to;
        public Converter<F, T> converter;

        public ConverterInfo(Class<F> from, Class<T> to, Converter<F, T> converter) {
            this.from = from;
            this.to = to;
            this.converter = converter;
        }
    }

    public static final class ConverterUtils {
        public static final <T, F> T convert(ConverterInfo<F, T> info, Object o) {
            if (info.from.isInstance(o)) {
                return info.converter.convert(o);
            }
            return null;
        }

        public static final <F, T> Converter<?, T> createInstanceofConverter(ConverterInfo<F, T> conv) {
            return ConverterUtils.createInstanceofConverter(conv.from, conv.converter);
        }

        public static final <F, T> Converter<?, T> createInstanceofConverter(final Class<F> from, final Converter<F, T> conv) {
            return new Converter<Object, T>(){

                @Override
                public T convert(Object o) {
                    if (!from.isInstance(o)) {
                        return null;
                    }
                    return conv.convert(o);
                }
            };
        }

        public static final <F, T> Converter<F, T> createInstanceofConverter(Converter<F, ?> conv, final Class<T> to) {
            return new Converter<F, T>(){

                @Override
                public T convert(F f) {
                    Object o = Converter.this.convert(f);
                    if (to.isInstance(o)) {
                        return o;
                    }
                    return null;
                }
            };
        }

        public static final <F, T> Converter<?, T> createDoubleInstanceofConverter(ConverterInfo<F, ?> conv, Class<T> to) {
            return ConverterUtils.createDoubleInstanceofConverter(conv.from, conv.converter, to);
        }

        public static final <F, T> Converter<?, T> createDoubleInstanceofConverter(final Class<F> from, final Converter<F, ?> conv, final Class<T> to) {
            return new Converter<Object, T>(){

                @Override
                public T convert(Object o) {
                    if (!from.isInstance(o)) {
                        return null;
                    }
                    Object o2 = conv.convert(o);
                    if (to.isInstance(o2)) {
                        return o2;
                    }
                    return null;
                }
            };
        }

        public static final <F, T> T[] convertUnsafe(F[] from, Converter<? super F, ? extends T> conv, Class<?> to) {
            return ConverterUtils.convert(from, conv, to);
        }

        public static final <F, T> T[] convert(F[] from, Converter<? super F, ? extends T> conv, Class<T> to) {
            Object[] ts = (Object[])Array.newInstance(to, from.length);
            int j = 0;
            int i = 0;
            while (i < from.length) {
                T t = conv.convert(from[i]);
                if (t != null) {
                    ts[j++] = t;
                }
                ++i;
            }
            if (j != ts.length) {
                return Arrays.copyOf(ts, j);
            }
            return ts;
        }
    }
}

