/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Verbosity;
import ch.njol.skript.config.Node;
import ch.njol.util.Pair;
import ch.njol.util.iterator.IteratorIterable;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public abstract class SkriptLogger {
    private static Node node = null;
    private static Verbosity verbosity = Verbosity.NORMAL;
    static boolean debug;
    private static final Deque<SubLog> subLogs;

    static {
        subLogs = new LinkedList<SubLog>();
    }

    public static final SubLog startSubLog() {
        SubLog subLog = new SubLog();
        subLogs.addLast(subLog);
        return subLog;
    }

    public static final void stopSubLog(SubLog log) {
        if (!subLogs.contains(log)) {
            return;
        }
        if (subLogs.removeLast() != log) {
            int i = 1;
            while (subLogs.removeLast() != log) {
                ++i;
            }
            throw new IllegalStateException(String.valueOf(i) + " sub log(s) was/were not stopped properly!");
        }
    }

    static void setVerbosity(Verbosity v) {
        verbosity = v;
        if (v.compareTo(Verbosity.DEBUG) >= 0) {
            debug = true;
        }
    }

    public static void log(Level level, String message) {
        if (node != null && level.intValue() >= Level.WARNING.intValue()) {
            if (node.getParent() != null) {
                SkriptLogger.logDirect(level, String.valueOf(message) + " (" + node.getConfig().getFileName() + ", line " + node.getLine() + (node.getOrig() == null ? "" : ": '" + node.getOrig().trim() + "')"));
            } else {
                SkriptLogger.logDirect(level, String.valueOf(message) + " (" + node.getConfig().getFileName() + " [unknown line])");
            }
        } else {
            SkriptLogger.logDirect(level, message);
        }
    }

    public static void setNode(Node node) {
        SkriptLogger.node = node == null || node.getParent() == null ? null : node;
    }

    static Node getNode() {
        return node;
    }

    public static void logDirect(Level level, String message) {
        if (!subLogs.isEmpty()) {
            subLogs.getLast().log.add(new Pair<Level, String>(level, message));
        } else {
            Bukkit.getLogger().log(level, "[Skript] " + message);
        }
    }

    public static void logDirect(Pair<Level, String> message) {
        if (!subLogs.isEmpty()) {
            subLogs.getLast().log.add(message);
        } else {
            Bukkit.getLogger().log((Level)message.first, "[Skript] " + (String)message.second);
        }
    }

    public static boolean log(Verbosity minVerb) {
        return minVerb.compareTo(verbosity) <= 0;
    }

    public static final class SubLog {
        private final Deque<Pair<Level, String>> log = new LinkedList<Pair<Level, String>>();

        SubLog() {
        }

        public final boolean printErrors(String def) {
            SkriptLogger.stopSubLog(this);
            boolean hasError = false;
            for (Pair<Level, String> e : this.log) {
                if (e.first != Level.SEVERE) continue;
                SkriptLogger.logDirect(e);
                hasError = true;
            }
            if (!hasError && def != null) {
                SkriptLogger.logDirect(Level.SEVERE, def);
            }
            return hasError;
        }

        public final boolean printErrors(CommandSender recipient, String def) {
            SkriptLogger.stopSubLog(this);
            boolean hasError = false;
            for (Pair<Level, String> e : this.log) {
                if (e.first != Level.SEVERE) continue;
                recipient.sendMessage((String)e.second);
                hasError = true;
            }
            if (!hasError && def != null) {
                recipient.sendMessage(def);
            }
            this.log.clear();
            return hasError;
        }

        public final void printLog() {
            SkriptLogger.stopSubLog(this);
            for (Pair<Level, String> e : this.log) {
                SkriptLogger.logDirect(e);
            }
        }

        public boolean hasErrors() {
            for (Pair<Level, String> e : this.log) {
                if (e.first != Level.SEVERE) continue;
                return true;
            }
            return false;
        }

        public String getLastError() {
            for (Pair<Level, String> e : new IteratorIterable<Pair<Level, String>>(this.log.descendingIterator())) {
                if (e.getKey() != Level.SEVERE) continue;
                return e.getValue();
            }
            return null;
        }

        public void clear() {
            this.log.clear();
        }
    }
}

