/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util.iterator;

import ch.njol.util.Checker;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CheckedIterator<T>
implements Iterator<T> {
    private final Iterator<T> iter;
    private final Checker<T> checker;
    private boolean calledNext = false;
    private T current;

    public CheckedIterator(Iterator<T> iter, Checker<T> checker) {
        this.iter = iter;
        this.checker = checker;
    }

    @Override
    public boolean hasNext() {
        this.calledNext = false;
        while (this.iter.hasNext()) {
            this.current = this.iter.next();
            if (!this.checker.check(this.current)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.calledNext && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.calledNext = true;
        return this.current;
    }

    @Override
    public void remove() {
        this.iter.remove();
    }
}

