/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import ch.njol.util.Validate;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;

public class EntityType {
    public final Class<? extends Entity> c;
    public int amount = -1;
    private static final Map<String, Class<? extends Entity>> names = new LinkedHashMap<String, Class<? extends Entity>>();

    static {
        names.put("arrow", Arrow.class);
        names.put("boat", Boat.class);
        names.put("chicken", Chicken.class);
        names.put("cow", Cow.class);
        names.put("creeper", Creeper.class);
        names.put("egg", Egg.class);
        names.put("ender crystal", EnderCrystal.class);
        names.put("ender dragon", EnderDragon.class);
        names.put("enderman", Enderman.class);
        names.put("ender pearl", EnderPearl.class);
        names.put("experience orb", ExperienceOrb.class);
        names.put("fireball", Fireball.class);
        names.put("fish", Fish.class);
        names.put("ghast", Ghast.class);
        names.put("giant", Giant.class);
        names.put("iron golem", IronGolem.class);
        names.put("dropped item", Item.class);
        names.put("magma cube", MagmaCube.class);
        names.put("powered minecart", PoweredMinecart.class);
        names.put("storage minecart", StorageMinecart.class);
        names.put("minecart", Minecart.class);
        names.put("mooshroom", MushroomCow.class);
        names.put("ocelot", Ocelot.class);
        names.put("painting", Painting.class);
        names.put("pig", Pig.class);
        names.put("pig zombie", PigZombie.class);
        names.put("player", Player.class);
        names.put("sheep", Sheep.class);
        names.put("silverfish", Silverfish.class);
        names.put("skeleton", Skeleton.class);
        names.put("slime", Slime.class);
        names.put("snowball", Snowball.class);
        names.put("snowman", Snowman.class);
        names.put("spider", Spider.class);
        names.put("squid", Squid.class);
        names.put("bottle o' enchanting", ThrownExpBottle.class);
        names.put("thrown potion", ThrownPotion.class);
        names.put("TNT", TNTPrimed.class);
        names.put("tnt", TNTPrimed.class);
        names.put("wolf", Wolf.class);
        names.put("zombie", Zombie.class);
        names.put("human", HumanEntity.class);
        names.put("creature", Creature.class);
        names.put("entity", Entity.class);
    }

    public EntityType(Class<? extends Entity> c, int amount) {
        Validate.notNull(c);
        this.c = c;
        this.amount = amount;
    }

    public EntityType(Entity e) {
        this.c = e.getClass();
    }

    public boolean isInstance(Entity entity) {
        return this.c.isInstance(entity);
    }

    public String toString() {
        return this.getAmount() == 1 ? EntityType.entityName(this.c) : String.valueOf(this.amount) + " " + Utils.toPlural(EntityType.entityName(this.c));
    }

    public int getAmount() {
        return this.amount == -1 ? 1 : this.amount;
    }

    public static String toString(Entity e) {
        return new EntityType(e).toString();
    }

    public static String toString(Class<? extends Entity> c) {
        return new EntityType(c, 1).toString();
    }

    public boolean sameType(EntityType other) {
        if (other == null) {
            return false;
        }
        return this.c == other.c;
    }

    public int hashCode() {
        return this.amount * this.c.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityType)) {
            return false;
        }
        EntityType other = (EntityType)obj;
        return this.amount == other.amount && this.c == other.c;
    }

    public static EntityType parse(String s) {
        int amount = -1;
        if (s.matches("\\d+ .+")) {
            amount = Integer.parseInt(s.split(" ", 2)[0]);
            s = s.split(" ", 2)[1];
        } else if (s.matches("(?i)an? .+")) {
            s = s.split(" ", 2)[1];
        }
        Pair<String, Boolean> p = Utils.getPlural(s, amount != 1 && amount != -1);
        s = (String)p.first;
        Class<? extends Entity> c = names.get(s.toLowerCase(Locale.ENGLISH));
        if (c == null) {
            return null;
        }
        return new EntityType(c, amount);
    }

    private static final String entityName(Class<? extends Entity> c) {
        for (Map.Entry<String, Class<? extends Entity>> p : names.entrySet()) {
            if (!p.getValue().isAssignableFrom(c)) continue;
            return p.getKey();
        }
        return "unknown entity type";
    }
}

