/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.loops;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.LoopExpr;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EntityType;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

public class LoopEntities
extends LoopExpr<Entity> {
    private Expression<EntityType> types;
    private Class<? extends Entity> returnType = Entity.class;
    private Expression<World> worlds;

    static {
        Skript.registerLoop(LoopEntities.class, Entity.class, "%entitytypes% [in [world[s]] %worlds%]", "entities of type[s] %entitytypes% [in [world[s]] %worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.types = exprs[0];
        this.worlds = exprs[1];
        if (this.types instanceof Literal && this.types.isSingle() && this.types.getAnd()) {
            this.returnType = ((EntityType)((Literal)this.types).getSingle()).c;
        }
        return true;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.returnType;
    }

    @Override
    protected Iterator<? extends Entity> iterator(Event e) {
        final World[] ws = this.worlds == null ? Bukkit.getWorlds().toArray(new World[0]) : this.worlds.getArray(e);
        return new Iterator<Entity>(e){
            final Class<? extends Entity>[] classes;
            private int w;
            Iterator<Entity> iter;
            {
                this.classes = Converter.ConverterUtils.convertUnsafe((EntityType[])LoopEntities.this.types.getArray(event), new Converter<EntityType, Class<? extends Entity>>(){

                    @Override
                    public Class<? extends Entity> convert(EntityType t) {
                        return t.c;
                    }
                }, Class.class);
                this.w = 0;
                this.iter = worldArray[this.w].getEntitiesByClasses((Class[])this.classes).iterator();
            }

            @Override
            public boolean hasNext() {
                while (!this.iter.hasNext()) {
                    ++this.w;
                    if (this.w >= ws.length) {
                        return false;
                    }
                    this.iter = ws[this.w].getEntitiesByClasses((Class[])this.classes).iterator();
                }
                return true;
            }

            @Override
            public Entity next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isLoopOf(String s) {
        return EntityType.parse((String)s).c.isAssignableFrom(this.returnType);
    }

    @Override
    public String getLoopDebugMessage(Event e) {
        return this.types + (this.worlds == null ? "" : " in worlds " + this.worlds);
    }

    @Override
    public String toString() {
        return "loop-" + EntityType.toString(this.returnType);
    }
}

