/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.loops;

import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopExpr;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.BlockSphereIterator;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class LoopBlockSphere
extends LoopExpr<Block> {
    private Expression<Float> radius;
    private Expression<Location> center;

    static {
        Skript.registerLoop(LoopBlockSphere.class, Block.class, "blocks in radius %float% [around %location%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.radius = vars[0];
        this.center = vars[1];
        return true;
    }

    @Override
    protected Iterator<Block> iterator(Event e) {
        return new BlockSphereIterator(this.center.getSingle(e), this.radius.getSingle(e).floatValue());
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public String getLoopDebugMessage(Event e) {
        return "blocks in radius " + this.radius.getDebugMessage(e) + " around " + this.center.getDebugMessage(e);
    }

    @Override
    public String toString() {
        return "the loop-block";
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("block");
    }
}

