/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.DefaultExpression;
import ch.njol.skript.api.intern.ConvertedLiteral;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class SimpleLiteral<T>
implements Literal<T>,
DefaultExpression<T> {
    protected final T[] data;
    protected final Class<T> c;
    private final boolean isDefault;
    private boolean and;

    public SimpleLiteral(T[] data, Class<T> c, boolean and) {
        this.data = data;
        this.c = c;
        this.setAnd(data.length == 1 || and);
        this.isDefault = false;
    }

    public SimpleLiteral(T data, boolean isDefault) {
        this.data = (Object[])Array.newInstance(data.getClass(), 1);
        this.data[0] = data;
        this.c = data.getClass();
        this.setAnd(true);
        this.isDefault = isDefault;
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public T[] getArray() {
        return this.getArray(null);
    }

    @Override
    public T getSingle() {
        return this.getSingle(null);
    }

    @Override
    public Class<T> getReturnType() {
        return this.c;
    }

    public <R> ConvertedLiteral<T, ? extends R> getConvertedExpression(Class<R> to) {
        if (to.isAssignableFrom(this.c)) {
            return new ConvertedLiteral(this, this.data, to);
        }
        Converter<T, R> p = Skript.getConverter(this.c, to);
        if (p == null) {
            return null;
        }
        R[] parsedData = Converter.ConverterUtils.convert(this.data, p, to);
        return new ConvertedLiteral(this, parsedData, to);
    }

    @Override
    public String getDebugMessage(Event e) {
        return "[" + this + "]";
    }

    @Override
    public String toString() {
        return Skript.toString(this.data, this.getAnd());
    }

    @Override
    public boolean isSingle() {
        return !this.getAnd() || this.data.length <= 1;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public T getSingle(Event e) {
        return Utils.getRandom(this.data);
    }

    @Override
    public T[] getArray(Event e) {
        return this.data;
    }

    @Override
    public <V> V getSingle(Event e, Converter<? super T, ? extends V> converter) {
        return converter.convert(this.getSingle());
    }

    @Override
    public <V> V[] getArray(Event e, Class<V> to, Converter<? super T, ? extends V> converter) {
        return Converter.ConverterUtils.convert(this.data, converter, to);
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, Condition cond) {
        return SimpleExpression.check(this.data, c, cond.isNegated(), this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.data, c, false, this.getAnd());
    }

    @Override
    public void setAnd(boolean and) {
        this.and = and;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    @Override
    public boolean getAnd() {
        return this.and;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }
}

