/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.WeatherType;
import org.bukkit.World;
import org.bukkit.event.Event;

public class ExprWeather
extends SimpleExpression<WeatherType> {
    private Expression<World> worlds;

    static {
        Skript.registerExpression(ExprWeather.class, WeatherType.class, "[the] weather [(in|of) %worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.worlds = vars[0];
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "weather in " + this.worlds.getDebugMessage(e);
    }

    protected WeatherType[] getAll(Event e) {
        return this.worlds.getArray(e, WeatherType.class, new Getter<WeatherType, World>(){

            @Override
            public WeatherType get(World w) {
                return WeatherType.fromWorld(w);
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.CLEAR || mode == Changer.ChangeMode.SET) {
            return WeatherType.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        switch (mode) {
            case CLEAR: {
                World[] worldArray = this.worlds.getArray(e);
                int n = worldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    World w = worldArray[n2];
                    w.setStorm(false);
                    w.setThundering(false);
                    ++n2;
                }
                break;
            }
            case SET: {
                WeatherType t = (WeatherType)((Object)delta);
                World[] worldArray = this.worlds.getArray(e);
                int n = worldArray.length;
                int n3 = 0;
                while (n3 < n) {
                    World w = worldArray[n3];
                    t.setWeather(w);
                    ++n3;
                }
                break;
            }
        }
    }

    @Override
    public Class<? extends WeatherType> getReturnType() {
        return WeatherType.class;
    }

    @Override
    public String toString() {
        return "the weather in " + this.worlds;
    }

    @Override
    public boolean isSingle() {
        return this.worlds.isSingle();
    }
}

