/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Getter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Slot;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ExprTool
extends SimpleExpression<Slot> {
    private Expression<Player> players;

    static {
        Skript.registerExpression(ExprTool.class, Slot.class, "[the] (tool|held item) [of %players%]", "%player%'[s] (tool|held item)");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        return true;
    }

    protected Slot[] getAll(final Event e) {
        if (e instanceof PlayerItemHeldEvent && this.players.isDefault()) {
            return this.players.getArray(e, Slot.class, new Getter<Slot, Player>(){

                @Override
                public Slot get(Player p) {
                    return new Slot((Inventory)p.getInventory(), ExprTool.this.getTime() >= 0 ? ((PlayerItemHeldEvent)e).getNewSlot() : ((PlayerItemHeldEvent)e).getPreviousSlot());
                }
            });
        }
        return this.players.getArray(e, Slot.class, new Getter<Slot, Player>(){

            @Override
            public Slot get(final Player p) {
                return new Slot((Inventory)p.getInventory(), p.getInventory().getHeldItemSlot()){

                    @Override
                    public void setItem(ItemStack item) {
                        p.setItemInHand(item);
                    }

                    @Override
                    public ItemStack getItem() {
                        return p.getItemInHand();
                    }

                    @Override
                    public String getDebugMessage(Event e) {
                        return String.valueOf(ExprTool.this.getTime() == 1 ? "future " : (ExprTool.this.getTime() == -1 ? "former " : "")) + "tool of " + p.getName();
                    }
                };
            }
        });
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return String.valueOf(this.getTime() == 1 ? "future " : (this.getTime() == -1 ? "former " : "")) + "tool of " + this.players.getDebugMessage(e);
        }
        return Skript.getDebugMessage(this.getSingle(e));
    }

    @Override
    public String toString() {
        return "the " + (this.getTime() == 1 ? "future " : (this.getTime() == -1 ? "former " : "")) + "tool of " + this.players;
    }

    @Override
    public boolean isSingle() {
        return this.players.isSingle();
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, PlayerItemHeldEvent.class, this.players);
    }
}

