/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.classes.DefaultChangers;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Time;
import org.bukkit.World;
import org.bukkit.event.Event;

public class ExprTime
extends SimpleExpression<Time> {
    private Expression<World> worlds = null;

    static {
        Skript.registerExpression(ExprTime.class, Time.class, "[the] time [(in|of) %worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.worlds = vars[0];
        return true;
    }

    protected Time[] getAll(Event e) {
        return this.worlds.getArray(e, Time.class, new Getter<Time, World>(){

            @Override
            public Time get(World w) {
                return new Time((int)w.getTime());
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.timeChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        DefaultChangers.timeChanger.change((World[])this.worlds.getArray(e), delta, mode);
    }

    @Override
    public Class<Time> getReturnType() {
        return Time.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "time in " + this.worlds.getDebugMessage(e);
        }
        return Skript.getDebugMessage(this.getAll(e));
    }

    @Override
    public String toString() {
        return "the time in " + this.worlds;
    }

    @Override
    public boolean isSingle() {
        return this.worlds.isSingle();
    }
}

