/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.event.Event;

public class ExprRandom
extends SimpleExpression<Double> {
    private Expression<Double> lower;
    private Expression<Double> upper;

    static {
        Skript.registerExpression(ExprRandom.class, Double.class, "[a] random number between %double% and %double%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.lower = vars[0];
        this.upper = vars[1];
        return true;
    }

    protected Double[] getAll(Event e) {
        double l = this.lower.getSingle(e);
        double u = this.upper.getSingle(e);
        return new Double[]{l + Math.random() * (u - l)};
    }

    @Override
    public Class<Double> getReturnType() {
        return Double.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "random number between " + this.lower + " and " + this.upper;
    }

    @Override
    public String toString() {
        return "a random number between " + this.lower + " and " + this.upper;
    }

    @Override
    public boolean isSingle() {
        return true;
    }
}

