/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class ExprHealth
extends SimpleExpression<Float> {
    private Expression<LivingEntity> entities;

    static {
        Skript.registerExpression(ExprHealth.class, Float.class, "[the] health [of %livingentities%]", "%livingentities%'[s] health");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.entities = vars[0];
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "health of " + this.entities.getDebugMessage(e);
    }

    protected Float[] getAll(final Event e) {
        if (e instanceof EntityDamageEvent && this.getTime() >= 0 && this.entities.isDefault()) {
            return this.entities.getArray(e, Float.class, new Getter<Float, LivingEntity>(){

                @Override
                public Float get(LivingEntity entity) {
                    return Float.valueOf(0.5f * (float)(entity.getHealth() - ((EntityDamageEvent)e).getDamage()));
                }
            });
        }
        return this.entities.getArray(e, Float.class, new Getter<Float, LivingEntity>(){

            @Override
            public Float get(LivingEntity entity) {
                return Float.valueOf(0.5f * (float)entity.getHealth());
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return Float.class;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        int s = 0;
        if (mode != Changer.ChangeMode.CLEAR) {
            s = Math.round(((Float)delta).floatValue() * 2.0f);
        }
        if (e instanceof EntityDamageEvent && this.getTime() >= 0 && this.entities.isDefault()) {
            ((EntityDamageEvent)e).setDamage(((LivingEntity)((EntityDamageEvent)e).getEntity()).getHealth() - s);
            return;
        }
        switch (mode) {
            case SET: 
            case CLEAR: {
                LivingEntity[] livingEntityArray = this.entities.getArray(e);
                int n = livingEntityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LivingEntity entity = livingEntityArray[n2];
                    entity.setHealth(s);
                    ++n2;
                }
                return;
            }
            case ADD: {
                LivingEntity[] livingEntityArray = this.entities.getArray(e);
                int n = livingEntityArray.length;
                int n3 = 0;
                while (n3 < n) {
                    LivingEntity entity = livingEntityArray[n3];
                    entity.setHealth(entity.getHealth() + s);
                    ++n3;
                }
                return;
            }
            case REMOVE: {
                LivingEntity[] livingEntityArray = this.entities.getArray(e);
                int n = livingEntityArray.length;
                int n4 = 0;
                while (n4 < n) {
                    LivingEntity entity = livingEntityArray[n4];
                    entity.setHealth(entity.getHealth() - s);
                    ++n4;
                }
                return;
            }
        }
    }

    @Override
    public Class<? extends Float> getReturnType() {
        return Float.class;
    }

    @Override
    public String toString() {
        return "the health of " + this.entities;
    }

    @Override
    public boolean isSingle() {
        return this.entities.isSingle();
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, EntityDamageEvent.class, this.entities);
    }
}

