/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Converter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerGameModeChangeEvent;

public class ExprGameMode
extends SimpleExpression<GameMode> {
    private Expression<Player> players;

    static {
        Skript.registerExpression(ExprGameMode.class, GameMode.class, "[the] game[ ]mode of %players%", "%players%'[s] game[ ]mode");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "gamemode of " + this.players.getDebugMessage(e);
    }

    protected GameMode[] getAll(Event e) {
        if (e instanceof PlayerGameModeChangeEvent && this.getTime() >= 0 && this.players.isDefault()) {
            return new GameMode[]{((PlayerGameModeChangeEvent)e).getNewGameMode()};
        }
        return this.players.getArray(e, GameMode.class, new Converter<Player, GameMode>(){

            @Override
            public GameMode convert(Player p) {
                return p.getGameMode();
            }
        });
    }

    @Override
    public Class<? extends GameMode> getReturnType() {
        return GameMode.class;
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return GameMode.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        GameMode m = (GameMode)delta;
        Player[] playerArray = this.players.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            p.setGameMode(m);
            ++n2;
        }
    }

    @Override
    public String toString() {
        return "the gamemode of " + this.players;
    }

    @Override
    public boolean isSingle() {
        return this.players.isSingle();
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, PlayerGameModeChangeEvent.class, this.players);
    }
}

