/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class EvtRightclick
extends SkriptEvent {
    private Literal<? extends ItemType> blocks = null;
    private Literal<? extends EntityType> entities = null;
    private Literal<ItemType> tools;

    static {
        Skript.registerEvent(EvtRightclick.class, Skript.array(PlayerInteractEvent.class, PlayerInteractEntityEvent.class), "rightclick[ing] [on %object%] [(with|using|holding) %itemtype%]");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        if (args[0] != null) {
            this.entities = args[0].getConvertedExpression(EntityType.class);
            if (this.entities == null) {
                this.blocks = args[0].getConvertedExpression(ItemType.class);
                if (this.blocks == null) {
                    Skript.error("'" + args[0] + "' is neither an entity type nor an item type");
                    return false;
                }
            }
        }
        this.tools = args[1];
        return true;
    }

    @Override
    public boolean check(final Event e) {
        if (!(e instanceof PlayerInteractEntityEvent) && ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_AIR && ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_BLOCK) {
            return false;
        }
        if (this.tools != null && !this.tools.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(((PlayerEvent)e).getPlayer().getItemInHand());
            }
        })) {
            return false;
        }
        if (this.blocks == null && this.entities == null) {
            return true;
        }
        if (e instanceof PlayerInteractEntityEvent && this.entities != null) {
            return this.entities.check(e, (Checker<? extends EntityType>)new Checker<EntityType>(){

                @Override
                public boolean check(EntityType t) {
                    return t.isInstance(((PlayerInteractEntityEvent)e).getRightClicked());
                }
            });
        }
        if (e instanceof PlayerInteractEvent && this.blocks != null) {
            return this.blocks.check(e, (Checker<? extends ItemType>)new Checker<ItemType>(){

                @Override
                public boolean check(ItemType t) {
                    return t.isOfType(((PlayerInteractEvent)e).getClickedBlock());
                }
            });
        }
        return false;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "rightclick on " + Skript.toString(this.blocks == null ? this.entities : this.blocks) + " holding " + Skript.toString(this.tools);
    }
}

