/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

public class EffTeleport
extends Effect {
    private Expression<Entity> entities;
    private Expression<Location> location;

    static {
        Skript.registerEffect(EffTeleport.class, "teleport %entities% to %location%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.entities = vars[0];
        this.location = vars[1];
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "teleport " + this.entities.getDebugMessage(e) + " to " + this.location.getDebugMessage(e);
    }

    @Override
    protected void execute(Event e) {
        Location to = this.location.getSingle(e);
        Block on = to.getBlock().getRelative(BlockFace.DOWN);
        if (Math.abs(to.getX() - (double)to.getBlockX() - 0.5) < 1.0E-16 && Math.abs(to.getZ() - (double)to.getBlockZ() - 0.5) < 1.0E-16 && on.getType() != Material.AIR) {
            to.setY((double)on.getY() + Utils.getBlockHeight(on.getType()));
        }
        Entity[] entityArray = this.entities.getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (to.getYaw() == 0.0f && to.getPitch() == 0.0f) {
                Location loc = to.clone();
                loc.setPitch(entity.getLocation().getPitch());
                loc.setYaw(entity.getLocation().getYaw());
                entity.teleport(loc);
            } else {
                entity.teleport(to);
            }
            ++n2;
        }
    }
}

