/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

public class CondPermission
extends Condition {
    private Expression<String> permissions;
    private Expression<CommandSender> senders;

    static {
        Skript.registerCondition(CondPermission.class, "[%commandsenders%] (do[es]n't|don't|do[es] not) have [the] permission[s] %strings%", "[%commandsenders%] ha(s|ve) [the] permission[s] %strings%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, SkriptParser.ParseResult parser) {
        this.senders = vars[0];
        this.permissions = vars[1];
        this.setNegated(matchedPattern == 0);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.senders.check(e, new Checker<CommandSender>(){

            @Override
            public boolean check(final CommandSender s) {
                return CondPermission.this.permissions.check(e, new Checker<String>(){

                    @Override
                    public boolean check(String perm) {
                        if (s.hasPermission(perm)) {
                            return true;
                        }
                        if (perm.startsWith("skript.")) {
                            int i = perm.lastIndexOf(46);
                            while (i > 0) {
                                if (s.hasPermission(String.valueOf(perm.substring(0, i + 1)) + "*")) {
                                    return true;
                                }
                                i = perm.lastIndexOf(46, i - 1);
                            }
                        }
                        return false;
                    }
                });
            }
        }, this);
    }

    @Override
    public String getDebugMessage(Event e) {
        return String.valueOf(this.senders.getDebugMessage(e)) + " " + (this.isNegated() ? "doesn't have" : "has") + " permission " + this.permissions.getDebugMessage(e);
    }
}

