/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Parser;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.SimpleLiteral;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.ItemData;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Offset;
import ch.njol.skript.util.Slot;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timeperiod;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.VariableString;
import ch.njol.skript.util.WeatherType;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class SkriptClasses {
    static {
        Skript.registerClass(new ClassInfo<WeatherType>(WeatherType.class, "weathertype").user("weather type", "weather ?types?", "weather conditions?", "weathers?").defaultExpression(new SimpleLiteral<WeatherType>(WeatherType.CLEAR, true)).parser(new Parser<WeatherType>(){

            @Override
            public WeatherType parse(String s) {
                return WeatherType.parse(s);
            }

            @Override
            public String toString(WeatherType o) {
                return o.toString();
            }
        }).serializer(new EnumSerializer<WeatherType>(WeatherType.class)));
        Skript.registerClass(new ClassInfo<EntityType>(EntityType.class, "entitytype").user("entity type", "entity ?types?", "enit(y|ies)").defaultExpression(new SimpleLiteral<EntityType>(new EntityType(Entity.class, 1), true)).parser(new Parser<EntityType>(){

            @Override
            public EntityType parse(String s) {
                return EntityType.parse(s);
            }

            @Override
            public String toString(EntityType t) {
                return t.toString();
            }
        }).serializer(new Serializer<EntityType>(){

            @Override
            public String serialize(EntityType t) {
                return String.valueOf(t.c.getName()) + "*" + t.amount;
            }

            @Override
            public EntityType deserialize(String s) {
                String[] split = s.split("\\*");
                if (split.length != 2) {
                    return null;
                }
                try {
                    return new EntityType(Class.forName(split[0]).asSubclass(Entity.class), Integer.parseInt(split[1]));
                }
                catch (LinkageError e) {
                    return null;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                catch (ClassCastException e) {
                    return null;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<VariableString>(VariableString.class, "variablestring").parser(new Parser<VariableString>(){

            @Override
            public VariableString parse(String s) {
                return null;
            }

            @Override
            public String toString(VariableString vs) {
                return vs.getDebugMessage(null);
            }
        }));
        Skript.registerClass(new ClassInfo<ItemType>(ItemType.class, "itemtype").user("item type", "item ?types?", "items", "materials").parser(new Parser<ItemType>(){

            @Override
            public ItemType parse(String s) {
                return Aliases.parseItemType(s);
            }

            @Override
            public String toString(ItemType t) {
                return t.toString();
            }

            @Override
            public String getDebugMessage(ItemType t) {
                return t.getDebugMessage();
            }
        }).serializer(new Serializer<ItemType>(){

            @Override
            public String serialize(ItemType t) {
                StringBuilder b = new StringBuilder();
                b.append(t.getInternalAmount());
                b.append("," + t.isAll());
                for (ItemData d : t.getTypes()) {
                    b.append("," + d.getId());
                    b.append(":" + d.dataMin);
                    b.append("/" + d.dataMax);
                }
                return t.toString();
            }

            @Override
            public ItemType deserialize(String s) {
                ItemType t;
                String[] split;
                block7: {
                    split = s.split("[,:/]");
                    if (split.length < 5 || (split.length - 2) % 3 != 0) {
                        return null;
                    }
                    t = new ItemType();
                    t.setAmount(Integer.parseInt(split[0]));
                    if (split[1].equals("true")) {
                        t.setAll(true);
                        break block7;
                    }
                    if (split[1].equals("false")) {
                        t.setAll(false);
                        break block7;
                    }
                    return null;
                }
                try {
                    int i = 2;
                    while (i < split.length) {
                        t.add(new ItemData(Integer.parseInt(split[i]), Short.parseShort(split[i + 1]), Short.parseShort(split[i + 2])));
                        i += 3;
                    }
                    return t;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Time>(Time.class, "time").user("time", "times?").defaultExpression(new EventValueExpression<Time>(Time.class)).parser(new Parser<Time>(){

            @Override
            public Time parse(String s) {
                return Time.parse(s);
            }

            @Override
            public String toString(Time t) {
                return t.toString();
            }
        }).serializer(new Serializer<Time>(){

            @Override
            public String serialize(Time t) {
                return "" + t.getTicks();
            }

            @Override
            public Time deserialize(String s) {
                try {
                    return new Time(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        new Timespan(0);
        Skript.registerClass(new ClassInfo<Timeperiod>(Timeperiod.class, "timeperiod").user("time period", "time ?periods?", "durations?").defaultExpression(new SimpleLiteral<Timeperiod>(new Timeperiod(0, 23999), true)).parser(new Parser<Timeperiod>(){

            @Override
            public Timeperiod parse(String s) {
                if (s.equalsIgnoreCase("day")) {
                    return new Timeperiod(0, 11999);
                }
                if (s.equalsIgnoreCase("dusk")) {
                    return new Timeperiod(12000, 13799);
                }
                if (s.equalsIgnoreCase("night")) {
                    return new Timeperiod(13800, 22199);
                }
                if (s.equalsIgnoreCase("dawn")) {
                    return new Timeperiod(22200, 23999);
                }
                int c = s.indexOf(45);
                if (c == -1) {
                    Time t = Time.parse(s);
                    if (t == null) {
                        return null;
                    }
                    return new Timeperiod(t.getTicks());
                }
                Time t1 = Time.parse(s.substring(0, c).trim());
                Time t2 = Time.parse(s.substring(c + 1).trim());
                if (t1 == null || t2 == null) {
                    return null;
                }
                return new Timeperiod(t1.getTicks(), t2.getTicks());
            }

            @Override
            public String toString(Timeperiod o) {
                return o.toString();
            }
        }).serializer(new Serializer<Timeperiod>(){

            @Override
            public String serialize(Timeperiod t) {
                return String.valueOf(t.start) + "-" + t.end;
            }

            @Override
            public Timeperiod deserialize(String s) {
                String[] split = s.split("-");
                if (split.length != 2) {
                    return null;
                }
                try {
                    return new Timeperiod(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Offset>(Offset.class, "offset").user("offset", "offset").defaultExpression(new SimpleLiteral<Offset>(new Offset(0.0, 0.0, 0.0), true)).parser(new Parser<Offset>(){

            @Override
            public Offset parse(String s) {
                return Offset.parse(s);
            }

            @Override
            public String toString(Offset o) {
                return o.toString();
            }
        }));
        Skript.registerClass(new ClassInfo<Slot>(Slot.class, "slot").defaultExpression(new EventValueExpression<Slot>(Slot.class)).changer(new Changer<Slot, ItemType>(){

            @Override
            public Class<ItemType> acceptChange(Changer.ChangeMode mode) {
                return ItemType.class;
            }

            public void change(Slot[] slots, ItemType delta, Changer.ChangeMode mode) {
                ItemType type = delta;
                if (type == null && mode != Changer.ChangeMode.CLEAR) {
                    return;
                }
                Slot[] slotArray = slots;
                int n = slots.length;
                int n2 = 0;
                while (n2 < n) {
                    Slot slot = slotArray[n2];
                    switch (mode) {
                        case SET: {
                            slot.setItem(type.getItem().getRandom());
                            break;
                        }
                        case ADD: {
                            slot.setItem(type.getItem().addTo(slot.getItem()));
                            break;
                        }
                        case REMOVE: {
                            slot.setItem(type.removeFrom(slot.getItem()));
                            break;
                        }
                        case CLEAR: {
                            slot.setItem(null);
                        }
                    }
                    ++n2;
                }
            }
        }).serializeAs(ItemStack.class));
        Skript.registerClass(new ClassInfo<Color>(Color.class, "color").user("color", "colou?rs?").parser(new Parser<Color>(){

            @Override
            public String toString(Color c) {
                return c.toString();
            }

            @Override
            public Color parse(String s) {
                return Color.byName(s);
            }
        }).serializer(new EnumSerializer<Color>(Color.class)));
    }
}

