/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.classes.Serializer;

public class EnumSerializer<T extends Enum<T>>
implements Serializer<T> {
    private final Class<T> c;

    public EnumSerializer(Class<T> c) {
        this.c = c;
    }

    @Override
    public String serialize(T t) {
        return ((Enum)t).name();
    }

    @Override
    public T deserialize(String s) {
        try {
            return Enum.valueOf(this.c, s);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

