/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Parser;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.SimpleLiteral;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;

public class DefaultClasses {
    static {
        Skript.registerClass(new ClassInfo<Object>(Object.class, "object"));
        Skript.registerClass(new ClassInfo<Integer>(Integer.class, "integer").user("integer", "integers?").defaultExpression(new SimpleLiteral<Integer>(1, true)).parser(new Parser<Integer>(){

            @Override
            public Integer parse(String s) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Integer o) {
                return o.toString();
            }
        }).serializer(new Serializer<Integer>(){

            @Override
            public String serialize(Integer i) {
                return "" + i;
            }

            @Override
            public Integer deserialize(String s) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Double>(Double.class, "double").user("number", "numbers?").defaultExpression(new SimpleLiteral<Double>(1.0, true)).parser(new Parser<Double>(){

            @Override
            public Double parse(String s) {
                try {
                    if (s.endsWith("%")) {
                        return Double.parseDouble(s.substring(0, s.length() - 1)) / 100.0;
                    }
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Double d) {
                return StringUtils.toString(d, 2);
            }
        }).serializer(new Serializer<Double>(){

            @Override
            public String serialize(Double d) {
                return "" + d;
            }

            @Override
            public Double deserialize(String s) {
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Float>(Float.class, "float").defaultExpression(new SimpleLiteral<Float>(Float.valueOf(1.0f), true)).parser(new Parser<Float>(){

            @Override
            public Float parse(String s) {
                try {
                    if (s.endsWith("%")) {
                        return Float.valueOf(Float.parseFloat(s.substring(0, s.length() - 1)) / 100.0f);
                    }
                    return Float.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Float f) {
                return StringUtils.toString(f.floatValue(), 2);
            }
        }).serializer(new Serializer<Float>(){

            @Override
            public String serialize(Float f) {
                return "" + f;
            }

            @Override
            public Float deserialize(String s) {
                try {
                    return Float.valueOf(Float.parseFloat(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Boolean>(Boolean.class, "boolean").parser(new Parser<Boolean>(){

            @Override
            public Boolean parse(String s) {
                byte i = Utils.parseBooleanNoError(s);
                if (i == 1) {
                    return Boolean.TRUE;
                }
                if (i == 0) {
                    return Boolean.FALSE;
                }
                return null;
            }

            @Override
            public String toString(Boolean o) {
                return o.toString();
            }
        }).serializer(new Serializer<Boolean>(){

            @Override
            public String serialize(Boolean b) {
                return "" + b;
            }

            @Override
            public Boolean deserialize(String s) {
                if (s.equals("true")) {
                    return Boolean.TRUE;
                }
                if (s.equals("false")) {
                    return Boolean.FALSE;
                }
                return null;
            }
        }));
        Skript.registerClass(new ClassInfo<Byte>(Byte.class, "byte").defaultExpression(new SimpleLiteral<Byte>((byte)1, true)).parser(new Parser<Byte>(){

            @Override
            public Byte parse(String s) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Byte o) {
                return o.toString();
            }
        }).serializer(new Serializer<Byte>(){

            @Override
            public String serialize(Byte b) {
                return "" + b;
            }

            @Override
            public Byte deserialize(String s) {
                try {
                    return Byte.parseByte(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Short>(Short.class, "short").defaultExpression(new SimpleLiteral<Short>((short)1, true)).parser(new Parser<Short>(){

            @Override
            public Short parse(String s) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Short o) {
                return o.toString();
            }
        }).serializer(new Serializer<Short>(){

            @Override
            public String serialize(Short s) {
                return "" + s;
            }

            @Override
            public Short deserialize(String s) {
                try {
                    return Short.parseShort(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Long>(Long.class, "long").defaultExpression(new SimpleLiteral<Long>(1L, true)).parser(new Parser<Long>(){

            @Override
            public Long parse(String s) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Long o) {
                return o.toString();
            }
        }).serializer(new Serializer<Long>(){

            @Override
            public String serialize(Long l) {
                return "" + l;
            }

            @Override
            public Long deserialize(String s) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<String>(String.class, "string").parser(new Parser<String>(){

            @Override
            public String parse(String s) {
                return null;
            }

            @Override
            public String toString(String s) {
                return s;
            }

            @Override
            public String getDebugMessage(String s) {
                return String.valueOf('\"') + s + '\"';
            }
        }).serializer(new Serializer<String>(){

            @Override
            public String serialize(String s) {
                return s;
            }

            @Override
            public String deserialize(String s) {
                return s;
            }
        }));
    }
}

