/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.api.Changer;
import ch.njol.skript.api.DefaultExpression;
import ch.njol.skript.api.Parser;
import ch.njol.skript.api.intern.SkriptAPIException;
import ch.njol.skript.classes.Serializer;
import java.util.regex.Pattern;

public class ClassInfo<T> {
    private final Class<T> c;
    private final String codeName;
    private DefaultExpression<T> defaultExpression = null;
    private Parser<T> parser = null;
    private String name = null;
    private Pattern[] userInputPatterns = null;
    private Changer<T, ?> changer = null;
    private Serializer<T> serializer = null;
    private Class<?> serializeAs = null;

    public ClassInfo(Class<T> c, String codeName) {
        this.c = c;
        this.codeName = codeName;
    }

    public ClassInfo<T> parser(Parser<T> parser) {
        this.parser = parser;
        return this;
    }

    public ClassInfo<T> user(String name, String ... userInputPatterns) {
        this.name = name;
        this.userInputPatterns = new Pattern[userInputPatterns.length];
        int i = 0;
        while (i < userInputPatterns.length) {
            this.userInputPatterns[i] = Pattern.compile("^" + userInputPatterns[i] + "$");
            ++i;
        }
        return this;
    }

    public ClassInfo<T> defaultExpression(DefaultExpression<T> defaultExpression) {
        this.defaultExpression = defaultExpression;
        return this;
    }

    public ClassInfo<T> serializer(Serializer<T> serializer) {
        if (this.serializeAs != null) {
            throw new SkriptAPIException("serializeAs already set");
        }
        this.serializer = serializer;
        return this;
    }

    public ClassInfo<T> serializeAs(Class<?> serializeAs) {
        if (this.serializer != null) {
            throw new SkriptAPIException("serializer already set");
        }
        this.serializeAs = serializeAs;
        return this;
    }

    public ClassInfo<T> changer(Changer<T, ?> changer) {
        this.changer = changer;
        return this;
    }

    public Class<T> getC() {
        return this.c;
    }

    public String getName() {
        return this.name;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public DefaultExpression<T> getDefaultExpression() {
        return this.defaultExpression;
    }

    public Parser<T> getParser() {
        return this.parser;
    }

    public Pattern[] getUserInputPatterns() {
        return this.userInputPatterns;
    }

    public Changer<T, ?> getChanger() {
        return this.changer;
    }

    public Serializer<T> getSerializer() {
        return this.serializer;
    }

    public Class<?> getSerializeAs() {
        return this.serializeAs;
    }
}

