/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.api.intern;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.intern.ConvertedExpression;
import ch.njol.skript.api.intern.SkriptAPIException;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SimpleExpression;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import org.bukkit.event.Event;

public class ConvertedLiteral<F, T>
extends ConvertedExpression<F, T>
implements Literal<T> {
    private final T[] data;

    public ConvertedLiteral(Literal<F> source, T[] data, Class<T> to) {
        super(source, to, null);
        this.data = data;
    }

    @Override
    public <R> Literal<? extends R> getConvertedExpression(Class<R> to) {
        if (to.isAssignableFrom(this.to)) {
            return this;
        }
        return ((Literal)this.source).getConvertedExpression(to);
    }

    @Override
    public String getDebugMessage(Event e) {
        return Skript.toString(this.data, this.getAnd());
    }

    @Override
    public String toString() {
        return Skript.toString(this.data, this.getAnd());
    }

    @Override
    public T[] getArray() {
        return this.data;
    }

    @Override
    public T[] getArray(Event e) {
        return this.getArray();
    }

    @Override
    public <V> V[] getArray(Event e, Class<V> to, Converter<? super T, ? extends V> converter) {
        return Converter.ConverterUtils.convert(this.data, converter, to);
    }

    @Override
    public T getSingle() {
        if (this.getAnd() && this.data.length > 1) {
            throw new SkriptAPIException("Call to getSingle on a non-single expression");
        }
        return Utils.getRandom(this.data);
    }

    @Override
    public T getSingle(Event e) {
        return this.getSingle();
    }

    @Override
    public <V> V getSingle(Event e, Converter<? super T, ? extends V> converter) {
        return converter.convert(this.getSingle());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.data, c, false, this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, Condition cond) {
        return SimpleExpression.check(this.data, c, cond.isNegated(), this.getAnd());
    }
}

