/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.Verbosity;
import ch.njol.skript.api.intern.Trigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.EventExecutor;

abstract class SkriptEventHandler {
    static Map<Class<? extends Event>, List<Trigger>> triggers = new HashMap<Class<? extends Event>, List<Trigger>>();
    public static final EventExecutor ee = new EventExecutor(){

        public void execute(Listener l, Event e) {
            SkriptEventHandler.check(e);
        }
    };

    private SkriptEventHandler() {
    }

    static void check(Event e) {
        if (!Skript.listenerEnabled) {
            return;
        }
        List<Trigger> ts = triggers.get(e.getClass());
        if (ts == null) {
            return;
        }
        long startEvent = System.nanoTime();
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("");
            Skript.info("== " + e.getClass().getName() + " ==");
        }
        if (e instanceof Cancellable && (!(e instanceof PlayerInteractEvent) || ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_AIR) && ((Cancellable)e).isCancelled()) {
            if (Skript.log(Verbosity.VERY_HIGH)) {
                Skript.info(" -x- was cancelled");
            }
            return;
        }
        for (Trigger t : ts) {
            if (!t.getEvent().check(e)) continue;
            if (Skript.log(Verbosity.VERY_HIGH)) {
                Skript.info("# " + t.getName());
            }
            long startTrigger = System.nanoTime();
            t.run(e);
            if (!Skript.log(Verbosity.VERY_HIGH)) continue;
            Skript.info("# " + t.getName() + " took " + 1.0 * (double)(System.nanoTime() - startTrigger) / 1000000.0 + " milliseconds");
        }
        Skript.enableListener();
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("== took " + 1.0 * (double)(System.nanoTime() - startEvent) / 1000000.0 + " milliseconds ==");
        }
    }

    static void addTrigger(Class<? extends Event>[] events, Trigger trigger) {
        Class<? extends Event>[] classArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> e = classArray[n2];
            List<Trigger> ts = triggers.get(e);
            if (ts == null) {
                ts = new ArrayList<Trigger>();
                triggers.put(e, ts);
            }
            ts.add(trigger);
            ++n2;
        }
    }
}

