/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables.base;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.intern.ConvertedVariable;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.util.Validate;
import org.bukkit.event.Event;

public abstract class VarVariable<T>
extends SimpleVariable<T> {
    protected Variable<? extends T> var;

    protected VarVariable() {
    }

    public VarVariable(SimpleVariable<? extends T> var) {
        Validate.notNull(var);
        this.var = var;
    }

    @Override
    protected <R> ConvertedVariable<T, ? extends R> getConvertedVar(Class<R> to) {
        Converter<T, R> conv = Skript.getConverter(this.getReturnType(), to);
        if (conv == null) {
            return null;
        }
        return new ConvertedVariable<T, R>(this.var, to, conv){

            @Override
            public String getDebugMessage(Event e) {
                return "{" + VarVariable.this.getDebugMessage(e) + "}->" + this.to.getName();
            }
        };
    }

    @Override
    protected T[] getAll(Event e) {
        return this.var.getArray(e);
    }

    @Override
    public boolean isSingle() {
        return this.var.isSingle();
    }

    @Override
    public void setAnd(boolean and) {
        super.setAnd(and);
        this.var.setAnd(and);
    }

    @Override
    public boolean getAnd() {
        return this.var.getAnd();
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.var.getReturnType();
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return this.var.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        this.var.change(e, delta, mode);
    }

    @Override
    public String toString() {
        return this.var.toString();
    }

    @Override
    public boolean setTime(int time) {
        return this.var.setTime(time);
    }

    @Override
    public int getTime() {
        return this.var.getTime();
    }

    @Override
    public boolean isDefault() {
        return this.var.isDefault();
    }
}

