/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Slot;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class VarTool
extends SimpleVariable<Slot> {
    private Variable<Player> players;

    static {
        Skript.registerVariable(VarTool.class, Slot.class, "[the] (tool|held item) [of %players%]", "%player%'[s] (tool|held item)");
    }

    @Override
    public boolean init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.players = vars[0];
        return true;
    }

    protected Slot[] getAll(final Event e) {
        if (e instanceof PlayerItemHeldEvent && this.players.isDefault()) {
            return this.players.getArray(e, Slot.class, new Getter<Slot, Player>(){

                @Override
                public Slot get(Player p) {
                    return new Slot((Inventory)p.getInventory(), VarTool.this.getTime() >= 0 ? ((PlayerItemHeldEvent)e).getNewSlot() : ((PlayerItemHeldEvent)e).getPreviousSlot());
                }
            });
        }
        return this.players.getArray(e, Slot.class, new Getter<Slot, Player>(){

            @Override
            public Slot get(final Player p) {
                return new Slot((Inventory)p.getInventory(), p.getInventory().getHeldItemSlot()){

                    @Override
                    public void setItem(ItemStack item) {
                        p.setItemInHand(item);
                    }

                    @Override
                    public ItemStack getItem() {
                        return p.getItemInHand();
                    }

                    @Override
                    public String getDebugMessage(Event e) {
                        return String.valueOf(VarTool.this.getTime() == 1 ? "future " : (VarTool.this.getTime() == -1 ? "former " : "")) + "tool of " + p.getName();
                    }
                };
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.slotChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        DefaultChangers.slotChanger.change(e, this, delta, mode);
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return String.valueOf(this.getTime() == 1 ? "future " : (this.getTime() == -1 ? "former " : "")) + "tool of " + this.players.getDebugMessage(e);
        }
        return Skript.getDebugMessage(this.getSingle(e));
    }

    @Override
    public String toString() {
        return "the " + (this.getTime() == 1 ? "future " : (this.getTime() == -1 ? "former " : "")) + "tool of " + this.players;
    }

    @Override
    public boolean isSingle() {
        return this.players.isSingle();
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, PlayerItemHeldEvent.class, this.players);
    }
}

