/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class VarTargetedBlock
extends SimpleVariable<Block> {
    private Variable<LivingEntity> entities;

    static {
        Skript.registerVariable(VarTargetedBlock.class, Block.class, "[the] target[ed] block[s] [of %players%]", "%player%'[s] target[ed] block[s]");
    }

    @Override
    public boolean init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.entities = vars[0];
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "targeted block of " + this.entities.getDebugMessage(e);
        }
        return Skript.getDebugMessage(this.getAll(e));
    }

    protected Block[] getAll(Event evt) {
        ArrayList<Block> targets = new ArrayList<Block>();
        LivingEntity[] livingEntityArray = this.entities.getArray(evt);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity e = livingEntityArray[n2];
            Block t = e.getTargetBlock(null, 100);
            if (t != null && t.getTypeId() != 0) {
                targets.add(t);
            }
            ++n2;
        }
        return targets.toArray(new Block[0]);
    }

    @Override
    public String toString() {
        return "the targeted block" + (this.isSingle() ? "" : "s") + " of " + this.entities;
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.blockChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        DefaultChangers.blockChanger.change(e, this, delta, mode);
    }

    @Override
    public boolean isSingle() {
        return this.entities.isSingle();
    }
}

