/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Slot;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class VarFurnaceSlot
extends SimpleVariable<Slot> {
    private Variable<Block> blocks;
    private int slot;
    private static final String[] slotNames;

    static {
        Skript.registerVariable(VarFurnaceSlot.class, Slot.class, "[the] ore [slot] [of %blocks%]", "%block%'[s] ore [slot]", "[the] fuel [slot] [of %blocks%]", "%block%'[s] fuel [slot]", "[the] result [slot] [of %blocks%]", "%block%'[s] result [slot]");
        slotNames = new String[]{"ore", "fuel", "result"};
    }

    @Override
    public boolean init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.blocks = vars[0];
        this.slot = matchedPattern / 2;
        return true;
    }

    protected Slot[] getAll(Event e) {
        if (this.blocks.isDefault() && (e instanceof FurnaceSmeltEvent || e instanceof FurnaceBurnEvent)) {
            return new Slot[]{new FurnaceEventSlot((Inventory)((Furnace)this.blocks.getSingle(e).getState()).getInventory())};
        }
        return this.blocks.getArray(e, Slot.class, new Getter<Slot, Block>(){

            @Override
            public Slot get(Block b) {
                if (b.getType() != Material.FURNACE) {
                    return null;
                }
                return new Slot((Inventory)((Furnace)b.getState()).getInventory(), VarFurnaceSlot.this.slot);
            }
        });
    }

    @Override
    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return String.valueOf(slotNames[this.slot]) + " slot of " + this.blocks.getDebugMessage(e);
        }
        return Skript.getDebugMessage(this.getSingle(e));
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.slotChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        DefaultChangers.slotChanger.change(e, this, delta, mode);
    }

    @Override
    public String toString() {
        return "the " + slotNames[this.slot] + " slot of " + this.blocks;
    }

    @Override
    public boolean isSingle() {
        return this.blocks.isSingle();
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.blocks, FurnaceSmeltEvent.class, FurnaceBurnEvent.class);
    }

    private final class FurnaceEventSlot
    extends Slot {
        public FurnaceEventSlot(Inventory invi) {
            super(invi, VarFurnaceSlot.this.slot);
        }

        @Override
        public ItemStack getItem() {
            ItemStack i = super.getItem();
            if (VarFurnaceSlot.this.getTime() == -1) {
                return i;
            }
            i.setAmount(i.getAmount() - 1);
            if (i.getAmount() == 0) {
                return new ItemStack(0, 1);
            }
            return i;
        }

        @Override
        public void setItem(final ItemStack item) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    item.setAmount(item.getAmount() + 1);
                    FurnaceEventSlot.super.setItem(item);
                }
            });
        }
    }
}

