/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Debuggable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class Slot
implements Debuggable {
    private final Inventory invi;
    private final int index;

    public Slot(Inventory invi, int index) {
        this.invi = invi;
        this.index = index;
    }

    protected Slot(PlayerInventory inventory) {
        this.invi = inventory;
        this.index = -1;
    }

    public Inventory getInventory() {
        return this.invi;
    }

    public int getIndex() {
        return this.index;
    }

    public ItemStack getItem() {
        return this.invi.getItem(this.index) == null ? new ItemStack(0, 1) : this.invi.getItem(this.index);
    }

    public void setItem(ItemStack item) {
        this.invi.setItem(this.index, item != null && item.getTypeId() != 0 ? item : null);
        if (this.invi instanceof PlayerInventory) {
            ((Player)this.invi.getHolder()).updateInventory();
        }
    }

    public String toString() {
        return Skript.toString(this.getItem());
    }

    @Override
    public String getDebugMessage(Event e) {
        if (this.invi.getHolder() != null) {
            return "slot " + this.index + " of inventory of " + this.invi.getHolder().toString();
        }
        return "slot " + this.index + " of " + this.invi.toString();
    }
}

