/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import java.util.Arrays;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class Offset {
    private final double[] mod;
    private final boolean isOffset;

    public Offset(double modX, double modY, double modZ) {
        this.mod = new double[]{modX, modY, modZ};
        this.isOffset = modX != 0.0 || modY != 0.0 || modZ != 0.0;
    }

    public Offset(double[] mod) {
        if (mod == null || mod.length != 3) {
            throw new IllegalArgumentException();
        }
        this.mod = mod;
        this.isOffset = mod[0] != 0.0 || mod[1] != 0.0 || mod[2] != 0.0;
    }

    public Block getRelative(Block block) {
        if (block == null || !this.isOffset) {
            return block;
        }
        return block.getRelative((int)Math.round(this.mod[0]), (int)Math.round(this.mod[1]), (int)Math.round(this.mod[2]));
    }

    public Location getRelative(Location location) {
        if (location == null) {
            return null;
        }
        if (!this.isOffset) {
            return location.clone();
        }
        return location.clone().add(this.mod[0], this.mod[1], this.mod[2]);
    }

    public Location setOff(Location location) {
        if (location == null || !this.isOffset) {
            return location;
        }
        return location.add(this.mod[0], this.mod[1], this.mod[2]);
    }

    public static Location[] setOff(Offset[] offsets, Location[] locations) {
        Location[] off = new Location[locations.length * offsets.length];
        int i = 0;
        while (i < locations.length) {
            int j = 0;
            while (j < offsets.length) {
                off[offsets.length * i + j] = offsets[j].getRelative(locations[i]);
                ++j;
            }
            ++i;
        }
        return off;
    }

    public static Block[] setOff(Offset[] offsets, Block[] blocks) {
        Block[] off = new Block[blocks.length * offsets.length];
        int i = 0;
        while (i < blocks.length) {
            int j = 0;
            while (j < offsets.length) {
                off[offsets.length * i + j] = offsets[j].getRelative(blocks[i]);
                ++j;
            }
            ++i;
        }
        return off;
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public String toString() {
        if (!this.isOffset) {
            return "at";
        }
        String r = "";
        BlockFace[] dirs = new BlockFace[]{BlockFace.SOUTH, BlockFace.UP, BlockFace.WEST};
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 1;
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray2[n2];
            if (this.mod[i] != 0.0) {
                r = this.mod[i] * (double)Utils.getBlockFaceDir(dirs[i], i) > 0.0 ? String.valueOf(r) + (r.isEmpty() ? "" : " ") + StringUtils.toString(this.mod[i], 2) + " " + Offset.getFaceName(dirs[i]) : String.valueOf(r) + (r.isEmpty() ? "" : " ") + StringUtils.toString(-this.mod[i], 2) + " " + Offset.getFaceName(dirs[i].getOppositeFace());
            }
            ++n2;
        }
        return r;
    }

    private static String getFaceName(BlockFace face) {
        switch (face) {
            case DOWN: {
                return "below";
            }
            case UP: {
                return "above";
            }
            case NORTH: 
            case EAST: 
            case SOUTH: 
            case WEST: {
                return face.toString().toLowerCase(Locale.ENGLISH);
            }
        }
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        return Arrays.hashCode(this.mod);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offset)) {
            return false;
        }
        Offset other = (Offset)obj;
        if (!this.isOffset && !other.isOffset) {
            return true;
        }
        return Arrays.equals(this.mod, other.mod);
    }

    public static Offset combine(Offset[] offsets) {
        if (offsets == null || offsets.length == 0) {
            return null;
        }
        if (offsets.length == 1) {
            return offsets[0];
        }
        double[] mod = new double[3];
        Offset[] offsetArray = offsets;
        int n = offsets.length;
        int n2 = 0;
        while (n2 < n) {
            Offset o = offsetArray[n2];
            int axis = 0;
            while (axis < 3) {
                int n3 = axis;
                mod[n3] = mod[n3] + o.mod[axis];
                ++axis;
            }
            ++n2;
        }
        return new Offset(mod);
    }

    public static Offset parse(String s) {
        if (s.isEmpty()) {
            return null;
        }
        if (s.equalsIgnoreCase("at")) {
            return new Offset(0.0, 0.0, 0.0);
        }
        double[] mod = new double[3];
        String[] args = s.split(" ");
        double amount = -1.0;
        int end = s.endsWith("of") ? args.length - 1 : args.length;
        int i = 0;
        while (i < end) {
            double n2;
            String arg;
            block8: {
                arg = args[i];
                n2 = Double.parseDouble(arg);
                if (amount == -1.0) break block8;
                return null;
            }
            try {
                amount = n2;
            }
            catch (NumberFormatException n2) {
                BlockFace f = Utils.getBlockFace(arg, false);
                if (f == null) {
                    return null;
                }
                if (amount == -1.0) {
                    amount = 1.0;
                }
                mod[0] = mod[0] + (double)f.getModX() * amount;
                mod[1] = mod[1] + (double)f.getModY() * amount;
                mod[2] = mod[2] + (double)f.getModZ() * amount;
                amount = -1.0;
            }
            ++i;
        }
        return new Offset(mod);
    }

    public Vector toVector() {
        return new Vector(this.mod[0], this.mod[1], this.mod[2]);
    }
}

