/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.api.ClassInfo;
import ch.njol.skript.api.Parser;
import ch.njol.skript.api.intern.SkriptAPIException;

public class Money {
    private static String plural;
    private static String singular;
    private final double amount;

    static {
        Skript.registerClass(new ClassInfo<Money>("money", "money", Money.class, null, new Parser<Money>(){

            @Override
            public Money parse(String s) {
                return Money.parse(s);
            }

            @Override
            public String toString(Money m) {
                return m.toString();
            }
        }, "money"));
        if (Skript.getEconomy() != null) {
            plural = Skript.getEconomy().currencyNamePlural().toLowerCase();
            singular = Skript.getEconomy().currencyNameSingular().toLowerCase();
        }
    }

    public Money(double amount) {
        if (Skript.getEconomy() == null) {
            throw new SkriptAPIException("can't create a new money instance if there's no economy plugin present");
        }
        this.amount = amount;
    }

    public double getAmount() {
        return this.amount;
    }

    public static final Money parse(String s) {
        if (Skript.getEconomy() == null) {
            Skript.error("No economy plugin detected");
            return null;
        }
        if (!plural.isEmpty() && s.toLowerCase().endsWith(plural)) {
            try {
                double d = Double.parseDouble(s.substring(0, s.length() - plural.length()).trim());
                if (d == 1.0 && !singular.equals(plural)) {
                    Skript.pluralWarning(s);
                }
                return new Money(d);
            }
            catch (NumberFormatException d) {
                // empty catch block
            }
        }
        if (!singular.isEmpty() && s.toLowerCase().endsWith(singular)) {
            try {
                double d = Double.parseDouble(s.substring(0, s.length() - singular.length()).trim());
                if (d != 1.0) {
                    Skript.pluralWarning(s);
                }
                return new Money(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return new Money(Double.parseDouble(s));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String toString() {
        return Skript.getEconomy().format(this.amount);
    }
}

