/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.api.intern.SkriptAPIException;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import ch.njol.util.iterator.SingleItemIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemData
implements Cloneable {
    int typeid = -1;
    public short dataMin = (short)-1;
    public short dataMax = (short)-1;
    private ItemType parent = null;

    public ItemData(int typeid) {
        this.typeid = typeid;
    }

    public ItemData(int typeid, short data) {
        if (data < -1) {
            throw new IllegalArgumentException("data (" + data + ") must be >= -1");
        }
        this.typeid = typeid;
        this.dataMin = this.dataMax = data;
    }

    public ItemData(int typeid, short dMin, short dMax) {
        if (dMin < -1 || dMax < -1) {
            throw new IllegalArgumentException("datas (" + dMin + "," + dMax + ") must be >= -1");
        }
        if (dMin == -1 && dMax != -1 || dMin != -1 && dMax == -1) {
            throw new IllegalArgumentException("dataMin (" + dMin + ") and dataMax (" + dMax + ") must either both be -1 or positive");
        }
        if (dMin > dMax) {
            throw new IllegalArgumentException("dataMin (" + dMin + ") must not be grater than dataMax (" + dMax + ")");
        }
        this.typeid = typeid;
        this.dataMin = dMin;
        this.dataMax = dMax;
    }

    public ItemData() {
        this.typeid = -1;
        this.dataMin = (short)-1;
        this.dataMax = (short)-1;
    }

    public ItemData(ItemStack i) {
        this.typeid = i.getTypeId();
        this.dataMin = this.dataMax = i.getDurability();
    }

    public ItemData(ItemData other) {
        this.typeid = other.typeid;
        this.dataMax = other.dataMax;
        this.dataMin = other.dataMin;
    }

    public void modified() {
        if (this.parent != null) {
            this.parent.modified();
        }
    }

    public void setParent(ItemType parent) {
        if (this.parent != null) {
            throw new SkriptAPIException("Can't set the parent of an ItemData if is is already set");
        }
        this.parent = parent;
    }

    public int getId() {
        return this.typeid;
    }

    public void setId(int typeid) {
        this.typeid = typeid;
        this.modified();
    }

    public boolean isOfType(ItemStack item) {
        if (item == null) {
            return this.typeid == 0;
        }
        return !(this.typeid != -1 && item.getTypeId() != this.typeid || this.dataMin != -1 && item.getData().getData() < this.dataMin || this.dataMax != -1 && item.getData().getData() > this.dataMax);
    }

    public String toString() {
        return Aliases.getMaterialName(this.typeid, this.dataMin, this.dataMax);
    }

    public String toString(boolean debug) {
        return debug ? Aliases.getDebugMaterialName(this.typeid, this.dataMin, this.dataMax) : Aliases.getMaterialName(this.typeid, this.dataMin, this.dataMax);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ItemData)) {
            return false;
        }
        ItemData other = (ItemData)obj;
        return other.typeid == this.typeid && other.dataMin == this.dataMin && other.dataMax == this.dataMax;
    }

    public int hashCode() {
        return this.typeid ^ this.dataMin << 8 ^ this.dataMax << 16;
    }

    public ItemData intersection(ItemData other) {
        if (other.dataMin != -1 && this.dataMin != -1 && (other.dataMax < this.dataMin || this.dataMax < other.dataMin) || other.typeid != -1 && this.typeid != -1 && other.typeid != this.typeid) {
            return null;
        }
        return new ItemData(this.typeid == -1 ? other.typeid : this.typeid, (short)Math.max(this.dataMin, other.dataMin), this.dataMax == -1 ? other.dataMax : (other.dataMax == -1 ? this.dataMax : (short)Math.min(this.dataMax, other.dataMax)));
    }

    public ItemStack getRandom() {
        int amount;
        int n = amount = this.parent == null ? 1 : this.parent.getAmount();
        if (this.dataMin == -1 && this.dataMax == -1) {
            return new ItemStack(this.typeid == -1 ? Utils.getRandom(Material.values(), 1).getId() : this.typeid, amount);
        }
        return new ItemStack(this.typeid == -1 ? Utils.getRandom(Material.values(), 1).getId() : this.typeid, amount, (short)(Skript.random.nextInt(this.dataMax - this.dataMin + 1) + this.dataMin));
    }

    public Iterator<ItemStack> getAll() {
        int amount;
        int n = amount = this.parent == null ? 1 : this.parent.getAmount();
        if (this.typeid == -1) {
            return new Iterator<ItemStack>(){
                private final Iterator<Material> iter = Arrays.asList(Material.values()).iterator();
                {
                    this.iter.next();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public ItemStack next() {
                    return new ItemStack(this.iter.next(), amount);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (this.dataMin == -1 && this.dataMax == -1) {
            return new SingleItemIterator<ItemStack>(new ItemStack(this.typeid, 1));
        }
        return new Iterator<ItemStack>(){
            private short data;
            {
                this.data = (short)(ItemData.this.dataMin - 1);
            }

            @Override
            public boolean hasNext() {
                return this.data < ItemData.this.dataMax;
            }

            @Override
            public ItemStack next() {
                this.data = (short)(this.data + 1);
                return new ItemStack(ItemData.this.typeid, amount, this.data, Byte.valueOf((byte)this.data));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ItemData clone() {
        return new ItemData(this);
    }

    public boolean hasDataRange() {
        return this.dataMin != this.dataMax;
    }
}

