/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.loops;

import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.intern.SkriptAPIException;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Container;
import ch.njol.util.StringUtils;
import ch.njol.util.iterator.ArrayIterator;
import java.util.Iterator;
import org.bukkit.event.Event;

public class LoopVarArguments
extends LoopVar<Object> {
    private Argument<?> arg;
    private Class<?> type;
    private boolean isContainer = false;

    static {
        Skript.registerLoop(LoopVarArguments.class, Object.class, "last argument", "argument(-| )<(\\d+)>", "<(?:(\\d*1)st|(\\d*2)nd|(\\d*3)rd|(\\d*[4-90])th)> argument", "arguments");
    }

    @Override
    public boolean init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        if (Commands.currentArguments == null) {
            Skript.error("you can't loop through any arguments outside of a command");
            return false;
        }
        switch (matchedPattern) {
            case 0: {
                this.arg = Commands.currentArguments.get(Commands.currentArguments.size() - 1);
                break;
            }
            case 1: 
            case 2: {
                int a = Integer.parseInt(parser.regexes.get(0).group(1));
                if (a - 1 >= Commands.currentArguments.size()) {
                    Skript.error("the command doesn't have a " + StringUtils.fancyOrderNumber(a) + " argument");
                    return false;
                }
                this.arg = Commands.currentArguments.get(a - 1);
                break;
            }
            case 3: {
                if (Commands.currentArguments.size() != 1) {
                    Skript.error("it's not possible to loop through multiple arguments (yet)");
                    return false;
                }
                this.arg = Commands.currentArguments.get(0);
            }
        }
        this.type = this.arg.getType();
        if (Container.class.isAssignableFrom(this.type)) {
            if (this.type.getAnnotation(Container.ContainerType.class) == null) {
                throw new SkriptAPIException("Missing annotation @ContainerType in container " + this.type.getName());
            }
            this.isContainer = true;
            this.type = this.type.getAnnotation(Container.ContainerType.class).value();
        }
        return true;
    }

    @Override
    protected Iterator<?> iterator(Event e) {
        if (this.arg.getCurrent().length == 0) {
            return null;
        }
        if (!this.isContainer) {
            return new ArrayIterator(this.arg.getCurrent());
        }
        final Object[] os = this.arg.getCurrent();
        return new Iterator<Object>(){
            private int i = 0;
            private Iterator<?> current;
            {
                this.current = ((Container)objectArray[this.i]).containerIterator();
            }

            @Override
            public boolean hasNext() {
                while (this.i < os.length - 1 && !this.current.hasNext()) {
                    this.current = ((Container)os[++this.i]).containerIterator();
                }
                return this.i < os.length - 1 || this.current.hasNext();
            }

            @Override
            public Object next() {
                return this.current.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.type;
    }

    @Override
    public String getLoopDebugMessage(Event e) {
        return "argument " + (this.arg.getIndex() + 1);
    }

    @Override
    public String toString() {
        return "the loop-argument";
    }

    @Override
    public boolean isLoopOf(String s) {
        if (s.equalsIgnoreCase("argument")) {
            return true;
        }
        Class<?> c = Skript.getClassFromUserInput(s);
        return c == this.type || c == this.arg.getType();
    }
}

