/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.util.WeatherType;
import ch.njol.util.Checker;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;

public class EvtWeatherChange
extends SkriptEvent {
    private Literal<WeatherType> types;

    static {
        Skript.registerEvent(EvtWeatherChange.class, Skript.array(WeatherChangeEvent.class, ThunderChangeEvent.class), "weather change [to %weathertypes%]");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, ExprParser.ParseResult parser) {
        this.types = args[0];
        return true;
    }

    @Override
    public boolean check(Event e) {
        if (this.types == null) {
            return true;
        }
        final boolean rain = e instanceof WeatherChangeEvent ? ((WeatherChangeEvent)e).toWeatherState() : ((ThunderChangeEvent)e).getWorld().hasStorm();
        final boolean thunder = e instanceof ThunderChangeEvent ? ((ThunderChangeEvent)e).toThunderState() : ((WeatherChangeEvent)e).getWorld().isThundering();
        return this.types.check(e, new Checker<WeatherType>(){

            @Override
            public boolean check(WeatherType t) {
                return t.isWeather(rain, thunder);
            }
        });
    }

    @Override
    public String getDebugMessage(Event e) {
        return "weather change" + (this.types == null ? "" : " to " + this.types);
    }
}

