/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class EvtRightclick
extends SkriptEvent {
    private Literal<ItemType> blocks = null;
    private Literal<EntityType> entities = null;
    private Literal<ItemType> tools;

    static {
        Skript.registerEvent(EvtRightclick.class, Skript.array(PlayerInteractEvent.class, PlayerInteractEntityEvent.class), "rightclick[ing] [on %entitytype%] [(with|using|holding) %itemtype%]", "rightclick[ing] [on %itemtype%] [(with|using|holding) %itemtype%]");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, ExprParser.ParseResult parser) {
        if (matchedPattern == 0) {
            this.entities = args[0];
        } else {
            this.blocks = args[0];
        }
        this.tools = args[1];
        return true;
    }

    @Override
    public boolean check(final Event e) {
        if (!(e instanceof PlayerInteractEntityEvent) && ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_AIR && ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_BLOCK) {
            return false;
        }
        if (this.tools != null && !this.tools.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(((PlayerEvent)e).getPlayer().getItemInHand());
            }
        })) {
            return false;
        }
        if (this.blocks == null && this.entities == null) {
            return true;
        }
        if (e instanceof PlayerInteractEntityEvent && this.entities != null) {
            return this.entities.check(e, new Checker<EntityType>(){

                @Override
                public boolean check(EntityType t) {
                    return t.isInstance(((PlayerInteractEntityEvent)e).getRightClicked());
                }
            });
        }
        if (e instanceof PlayerInteractEvent && this.blocks != null) {
            return this.blocks.check(e, new Checker<ItemType>(){

                @Override
                public boolean check(ItemType t) {
                    return t.isOfType(((PlayerInteractEvent)e).getClickedBlock());
                }
            });
        }
        return false;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "rightclick on " + Skript.toString(this.blocks == null ? this.entities : this.blocks) + " holding " + Skript.toString(this.tools);
    }
}

