/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.util.EntityType;
import ch.njol.util.Checker;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class EvtEntity
extends SkriptEvent {
    Literal<EntityType> types;

    static {
        Skript.registerEvent(EvtEntity.class, EntityDeathEvent.class, "death [of %entitytypes%]");
        Skript.registerEvent(EvtEntity.class, CreatureSpawnEvent.class, "spawn[ing] [of %entitytypes%]");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, ExprParser.ParseResult parser) {
        this.types = args[0];
        return true;
    }

    @Override
    public boolean check(Event e) {
        if (this.types == null) {
            return true;
        }
        final Entity en = Skript.getEventValue(e, Entity.class, 0);
        if (en == null) {
            throw new RuntimeException("no entity event value for entity death/spawn");
        }
        return this.types.check(e, new Checker<EntityType>(){

            @Override
            public boolean check(EntityType t) {
                return t.isInstance(en);
            }
        });
    }

    @Override
    public String getDebugMessage(Event e) {
        return "death/spawn" + (this.types == null ? "" : " of " + this.types);
    }
}

