/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.painting.PaintingBreakEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;

public class EvtBlock
extends SkriptEvent {
    private Literal<ItemType> types;
    private boolean mine = false;

    static {
        Skript.registerEvent(EvtBlock.class, Skript.array(BlockBreakEvent.class, PaintingBreakEvent.class), "(break[ing]|min(e|ing)) [[of] %itemtypes%]");
        Skript.registerEvent(EvtBlock.class, BlockBurnEvent.class, "burn[ing] [[of] %itemtypes%]");
        Skript.registerEvent(EvtBlock.class, Skript.array(BlockPlaceEvent.class, PaintingPlaceEvent.class), "plac(e|ing) [[of] %itemtypes%]");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, ExprParser.ParseResult parser) {
        this.types = args[0];
        this.mine = parser.expr.toLowerCase().startsWith("min");
        return true;
    }

    @Override
    public boolean check(Event e) {
        if (this.mine && e instanceof BlockBreakEvent && ((BlockBreakEvent)e).getBlock().getDrops(((BlockBreakEvent)e).getPlayer().getItemInHand()).isEmpty()) {
            return false;
        }
        if (this.types == null) {
            return true;
        }
        final Block b = Skript.getEventValue(e, Block.class, 0);
        if (b == null) {
            return false;
        }
        return this.types.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(b);
            }
        });
    }

    @Override
    public String getDebugMessage(Event e) {
        return "break/place/burn of " + Skript.toString(this.types);
    }
}

