/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Offset;
import org.bukkit.TreeType;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class EffTree
extends Effect {
    private Variable<Offset> offsets;
    private Variable<Block> blocks;
    private Variable<TreeType> type;

    static {
        Skript.registerEffect(EffTree.class, "(grow|create|generate) tree [of type %treetype%] %offsets% %blocks%", "(grow|create|generate) %treetype% [tree] %offsets% %blocks%");
    }

    @Override
    public boolean init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.type = vars[0];
        this.offsets = vars[1];
        this.blocks = vars[2];
        return true;
    }

    @Override
    public void execute(Event e) {
        TreeType type = this.type.getSingle(e);
        if (type == null) {
            return;
        }
        Block[] blockArray = Offset.setOff(this.offsets.getArray(e), this.blocks.getArray(e));
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block b = blockArray[n2];
            b.getWorld().generateTree(b.getLocation(), type);
            ++n2;
        }
    }

    @Override
    public String getDebugMessage(Event e) {
        return "grow tree of type " + this.type.getDebugMessage(e) + " " + this.offsets.getDebugMessage(e) + " " + this.blocks.getDebugMessage(e);
    }
}

