/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

public class EffTeleport
extends Effect {
    private Variable<Entity> entities;
    private Variable<Location> location;

    static {
        Skript.registerEffect(EffTeleport.class, "teleport %entities% to %location%");
    }

    @Override
    public boolean init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.entities = vars[0];
        this.location = vars[1];
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        return "teleport " + this.entities.getDebugMessage(e) + " to " + this.location.getDebugMessage(e);
    }

    @Override
    protected void execute(Event e) {
        Location to = this.location.getSingle(e);
        Block on = to.getBlock().getRelative(BlockFace.DOWN);
        if (0.4 < to.getX() - (double)to.getBlockX() && to.getX() - (double)to.getBlockX() < 0.6 && 0.4 < to.getZ() - (double)to.getBlockZ() && to.getZ() - (double)to.getBlockZ() < 0.6 && on.getType() != Material.AIR) {
            to.setY((double)on.getY() + Utils.getBlockHeight(on.getType()));
        }
        Entity[] entityArray = this.entities.getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            Location loc = to.clone();
            loc.setPitch(entity.getLocation().getPitch());
            loc.setYaw(entity.getLocation().getYaw());
            entity.teleport(loc);
            ++n2;
        }
    }
}

