/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Effect;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import org.bukkit.event.Event;

public class EffAdd
extends Effect {
    private Variable<?> added;
    private Variable<?> adder;

    static {
        Skript.registerEffect(EffAdd.class, "(add|give) %objects% to %objects%", "give %objects% %objects%");
    }

    @Override
    public boolean init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        if (matchedPattern == 0) {
            this.adder = vars[0];
            this.added = vars[1];
        } else {
            this.adder = vars[1];
            this.added = vars[0];
        }
        if (this.added instanceof UnparsedLiteral) {
            return false;
        }
        Class<?> r = this.added.acceptChange(Changer.ChangeMode.ADD);
        if (r == null) {
            Skript.error(this.added + " can't have something added to it");
            return false;
        }
        boolean single = true;
        if (r.isArray()) {
            single = false;
            r = r.getComponentType();
        }
        if (!r.isAssignableFrom(this.adder.getReturnType())) {
            Variable<?> v = this.adder.getConvertedVariable(r);
            if (v == null) {
                Skript.error(this.adder + " can't be added to " + this.added);
                return false;
            }
            this.adder = v;
        }
        if (!this.adder.isSingle() && single) {
            Skript.error(this.added + " can only be set to one " + Skript.getExactClassName(r) + ", but multiple are given");
            return false;
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        this.added.change(e, this.adder, Changer.ChangeMode.ADD);
    }

    @Override
    public String getDebugMessage(Event e) {
        return "add " + this.adder.getDebugMessage(e) + " to " + this.added.getDebugMessage(null);
    }
}

