/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.data;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Slot;
import ch.njol.skript.util.Time;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class DefaultConverters {
    static {
        Skript.registerConverter(Integer.class, Float.class, new Converter<Integer, Float>(){

            @Override
            public Float convert(Integer i) {
                return Float.valueOf(i.floatValue());
            }
        });
        Skript.registerConverter(Integer.class, Double.class, new Converter<Integer, Double>(){

            @Override
            public Double convert(Integer i) {
                return i.doubleValue();
            }
        });
        Skript.registerConverter(Float.class, Double.class, new Converter<Float, Double>(){

            @Override
            public Double convert(Float f) {
                return f.doubleValue();
            }
        });
        Skript.registerConverter(Double.class, Float.class, new Converter<Double, Float>(){

            @Override
            public Float convert(Double d) {
                return Float.valueOf(d.floatValue());
            }
        });
        Skript.registerConverter(OfflinePlayer.class, PlayerInventory.class, new Converter<OfflinePlayer, PlayerInventory>(){

            @Override
            public PlayerInventory convert(OfflinePlayer p) {
                if (p == null || !p.isOnline()) {
                    return null;
                }
                return p.getPlayer().getInventory();
            }
        });
        Skript.registerConverter(CommandSender.class, Player.class, new Converter<CommandSender, Player>(){

            @Override
            public Player convert(CommandSender s) {
                if (s instanceof Player) {
                    return (Player)s;
                }
                return null;
            }
        });
        Skript.registerConverter(Block.class, Inventory.class, new Converter<Block, Inventory>(){

            @Override
            public Inventory convert(Block b) {
                if (b == null) {
                    return null;
                }
                if (b.getState() instanceof InventoryHolder) {
                    return ((InventoryHolder)b.getState()).getInventory();
                }
                return null;
            }
        });
        Skript.registerConverter(Location.class, Block.class, new Converter<Location, Block>(){

            @Override
            public Block convert(Location l) {
                if (l == null) {
                    return null;
                }
                return l.getBlock();
            }
        });
        Skript.registerConverter(Block.class, Location.class, new Converter<Block, Location>(){

            @Override
            public Location convert(Block b) {
                if (b == null) {
                    return null;
                }
                return b.getLocation().add(0.5, 0.5, 0.5);
            }
        });
        Skript.registerConverter(Entity.class, Location.class, new Converter<Entity, Location>(){

            @Override
            public Location convert(Entity e) {
                if (e == null) {
                    return null;
                }
                return e.getLocation();
            }
        });
        Skript.registerConverter(Entity.class, EntityType.class, new Converter<Entity, EntityType>(){

            @Override
            public EntityType convert(Entity e) {
                return new EntityType(e.getClass(), 1);
            }
        });
        Skript.registerConverter(Location.class, World.class, new Converter<Location, World>(){

            @Override
            public World convert(Location l) {
                if (l == null) {
                    return null;
                }
                return l.getWorld();
            }
        });
        Skript.registerConverter(ItemStack.class, ItemType.class, new Converter<ItemStack, ItemType>(){

            @Override
            public ItemType convert(ItemStack i) {
                if (i == null) {
                    return null;
                }
                return new ItemType(i);
            }
        });
        Skript.registerConverter(Slot.class, ItemStack.class, new Converter<Slot, ItemStack>(){

            @Override
            public ItemStack convert(Slot s) {
                if (s == null) {
                    return null;
                }
                ItemStack i = s.getItem();
                if (i == null) {
                    return new ItemStack(0, 1);
                }
                return i;
            }
        });
        Skript.registerConverter(Item.class, ItemStack.class, new Converter<Item, ItemStack>(){

            @Override
            public ItemStack convert(Item i) {
                if (i == null) {
                    return null;
                }
                return i.getItemStack();
            }
        });
        Skript.registerConverter(OfflinePlayer.class, InventoryHolder.class, new Converter<OfflinePlayer, InventoryHolder>(){

            @Override
            public InventoryHolder convert(OfflinePlayer p) {
                if (p == null || !p.isOnline()) {
                    return null;
                }
                return p.getPlayer();
            }
        });
        Skript.registerConverter(World.class, Time.class, new Converter<World, Time>(){

            @Override
            public Time convert(World w) {
                if (w == null) {
                    return null;
                }
                return new Time((int)w.getTime());
            }
        });
    }
}

