/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.data;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Comparator;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timeperiod;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class DefaultComparators {
    static {
        Skript.registerComparator(Number.class, Number.class, new Comparator<Number, Number>(){

            @Override
            public Comparator.Relation compare(Number n1, Number n2) {
                if (n1 == null || n2 == null) {
                    return Comparator.Relation.NOT_EQUAL;
                }
                return Comparator.Relation.get(n1.doubleValue() - n2.doubleValue());
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Skript.registerComparator(ItemStack.class, ItemType.class, new Comparator<ItemStack, ItemType>(){

            @Override
            public Comparator.Relation compare(ItemStack is, ItemType it) {
                if (it == null) {
                    return Comparator.Relation.NOT_EQUAL;
                }
                return Comparator.Relation.get(it.isOfType(is));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Skript.registerComparator(Block.class, ItemType.class, new Comparator<Block, ItemType>(){

            @Override
            public Comparator.Relation compare(Block b, ItemType it) {
                if (it == null) {
                    return Comparator.Relation.NOT_EQUAL;
                }
                return Comparator.Relation.get(it.isOfType(b));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Skript.registerComparator(Block.class, Block.class, new Comparator<Block, Block>(){

            @Override
            public Comparator.Relation compare(Block b1, Block b2) {
                if (b1 == null || b2 == null) {
                    return Comparator.Relation.NOT_EQUAL;
                }
                return Comparator.Relation.get(b1.equals(b2));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Skript.registerComparator(Entity.class, EntityType.class, new Comparator<Entity, EntityType>(){

            @Override
            public Comparator.Relation compare(Entity e, EntityType t) {
                if (t == null || e == null) {
                    return Comparator.Relation.NOT_EQUAL;
                }
                return Comparator.Relation.get(t.isInstance(e));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Skript.registerComparator(Time.class, Time.class, new Comparator<Time, Time>(){

            @Override
            public Comparator.Relation compare(Time t1, Time t2) {
                return Comparator.Relation.get(t1.getTicks() - t2.getTicks());
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Skript.registerComparator(Time.class, Timeperiod.class, new Comparator<Time, Timeperiod>(){

            @Override
            public Comparator.Relation compare(Time t, Timeperiod p) {
                if (p == null || t == null) {
                    return Comparator.Relation.NOT_EQUAL;
                }
                return Comparator.Relation.get(p.contains(t));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Skript.registerComparator(String.class, String.class, new Comparator<String, String>(){

            @Override
            public Comparator.Relation compare(String s1, String s2) {
                if (s1 == null) {
                    return Comparator.Relation.NOT_EQUAL;
                }
                return Comparator.Relation.get(s1.equalsIgnoreCase(s2));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
    }
}

