/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.data;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.api.ClassInfo;
import ch.njol.skript.api.Parser;
import ch.njol.skript.lang.SimpleLiteral;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import ch.njol.skript.variables.base.EventValueVariable;
import ch.njol.util.StringUtils;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class DefaultClasses {
    static {
        Skript.registerClass(new ClassInfo<Object>("object", Object.class, null, null));
        Skript.registerClass(new ClassInfo<Float>("float", Float.class, new SimpleLiteral<Float>(Float.valueOf(1.0f), true), new Parser<Float>(){

            @Override
            public Float parse(String s) {
                try {
                    if (s.endsWith("%")) {
                        return Float.valueOf(Float.parseFloat(s.substring(0, s.length() - 1)) / 100.0f);
                    }
                    return Float.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Float f) {
                return StringUtils.toString(f.floatValue(), 2);
            }
        }));
        Skript.registerClass(new ClassInfo<Double>("number", "double", Double.class, new SimpleLiteral<Double>(1.0, true), new Parser<Double>(){

            @Override
            public Double parse(String s) {
                try {
                    if (s.endsWith("%")) {
                        return Double.parseDouble(s.substring(0, s.length() - 1)) / 100.0;
                    }
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Double d) {
                return StringUtils.toString(d, 2);
            }
        }, "number"));
        Skript.registerClass(new ClassInfo<Boolean>("boolean", Boolean.class, null, new Parser<Boolean>(){

            @Override
            public Boolean parse(String s) {
                byte i = Utils.parseBooleanNoError(s);
                if (i == 1) {
                    return Boolean.TRUE;
                }
                if (i == 0) {
                    return Boolean.FALSE;
                }
                return null;
            }

            @Override
            public String toString(Boolean o) {
                return o.toString();
            }
        }));
        Skript.registerClass(new ClassInfo<Byte>("byte", Byte.class, new SimpleLiteral<Byte>((byte)1, true), new Parser<Byte>(){

            @Override
            public Byte parse(String s) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Byte o) {
                return o.toString();
            }
        }));
        Skript.registerClass(new ClassInfo<Short>("short", Short.class, new SimpleLiteral<Short>((short)1, true), new Parser<Short>(){

            @Override
            public Short parse(String s) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Short o) {
                return o.toString();
            }
        }));
        Skript.registerClass(new ClassInfo<Integer>("integer", "integer", Integer.class, new SimpleLiteral<Integer>(1, true), new Parser<Integer>(){

            @Override
            public Integer parse(String s) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Integer o) {
                return o.toString();
            }
        }, "integers?"));
        Skript.registerClass(new ClassInfo<Long>("long", Long.class, new SimpleLiteral<Long>(1L, true), new Parser<Long>(){

            @Override
            public Long parse(String s) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Long o) {
                return o.toString();
            }
        }));
        Skript.registerClass(new ClassInfo<String>("string", String.class, null, new Parser<String>(){

            @Override
            public String parse(String s) {
                return null;
            }

            @Override
            public String toString(String s) {
                return s;
            }

            @Override
            public String getDebugMessage(String s) {
                return String.valueOf('\"') + s + '\"';
            }
        }));
        Skript.registerClass(new ClassInfo<TreeType>("tree type", "treetype", TreeType.class, new SimpleLiteral<TreeType>(TreeType.TREE, true), new Parser<TreeType>(){

            @Override
            public TreeType parse(String s) {
                if ((s = s.toLowerCase(Locale.ENGLISH)).endsWith(" tree")) {
                    s = s.substring(0, s.length() - " tree".length());
                }
                if (s.equals("regular")) {
                    return TreeType.TREE;
                }
                if (s.equals("normal")) {
                    return TreeType.TREE;
                }
                if (s.equals("big")) {
                    return TreeType.BIG_TREE;
                }
                if (s.equals("fir")) {
                    return TreeType.REDWOOD;
                }
                if (s.equals("tall fir")) {
                    return TreeType.TALL_REDWOOD;
                }
                if (s.equals("big fir")) {
                    return TreeType.TALL_REDWOOD;
                }
                if (s.equals("big redwood")) {
                    return TreeType.TALL_REDWOOD;
                }
                try {
                    return TreeType.valueOf((String)s.toUpperCase(Locale.ENGLISH).replace(' ', '_'));
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }

            @Override
            public String toString(TreeType o) {
                return o.toString().toLowerCase().replace('_', ' ');
            }
        }, "tree ?type", "tree"));
        Skript.registerClass(new ClassInfo<Entity>("entity", Entity.class, new EventValueVariable<Entity>(Entity.class), new Parser<Entity>(){

            @Override
            public Entity parse(String s) {
                return null;
            }

            @Override
            public String toString(Entity e) {
                return EntityType.toString(e);
            }
        }));
        Skript.registerClass(new ClassInfo<LivingEntity>("livingentity", LivingEntity.class, new EventValueVariable<LivingEntity>(LivingEntity.class), null));
        Skript.registerClass(new ClassInfo<Block>("block", Block.class, new EventValueVariable<Block>(Block.class), new Parser<Block>(){

            @Override
            public Block parse(String s) {
                return null;
            }

            @Override
            public String toString(Block b) {
                return ItemType.toString(new ItemStack(b.getTypeId(), 1, (short)b.getState().getRawData()));
            }

            @Override
            public String getDebugMessage(Block b) {
                return String.valueOf(this.toString(b)) + " block (" + b.getWorld().getName() + "|" + b.getX() + "/" + b.getY() + "/" + b.getZ() + ")";
            }
        }));
        Skript.registerClass(new ClassInfo<Location>("location", Location.class, new EventValueVariable<Location>(Location.class), new Parser<Location>(){

            @Override
            public Location parse(String s) {
                return null;
            }

            @Override
            public String toString(Location l) {
                return "x: " + StringUtils.toString(l.getX(), 2) + ", y: " + StringUtils.toString(l.getY(), 2) + ", z: " + StringUtils.toString(l.getZ(), 2);
            }

            @Override
            public String getDebugMessage(Location l) {
                return "(" + l.getWorld().getName() + "|" + l.getX() + "/" + l.getY() + "/" + l.getZ() + "|yaw=" + l.getYaw() + "/pitch=" + l.getPitch() + ")";
            }
        }));
        Skript.registerClass(new ClassInfo<World>("world", "world", World.class, new EventValueVariable<World>(World.class), new Parser<World>(){

            @Override
            public World parse(String s) {
                if (!s.matches("\".+\"")) {
                    return null;
                }
                if (s.matches("(?i)^\"world .+")) {
                    return Bukkit.getWorld((String)s.substring("\"world ".length(), s.length() - 1));
                }
                return Bukkit.getWorld((String)s.substring(1, s.length() - 1));
            }

            @Override
            public String toString(World w) {
                return w.getName();
            }
        }, "worlds?"), true, "string");
        Skript.registerClass(new ClassInfo<Inventory>("inventory", Inventory.class, new EventValueVariable<Inventory>(Inventory.class), new Parser<Inventory>(){

            @Override
            public Inventory parse(String s) {
                return null;
            }

            @Override
            public String toString(Inventory i) {
                return "inventory of " + Skript.toString(i.getHolder());
            }

            @Override
            public String getDebugMessage(Inventory i) {
                return "inventory of " + Skript.getDebugMessage(i.getHolder());
            }
        }));
        Skript.registerClass(new ClassInfo<Player>("player", "player", Player.class, new EventValueVariable<Player>(Player.class), new Parser<Player>(){

            @Override
            public Player parse(String s) {
                if (Skript.isLoading()) {
                    return null;
                }
                List ps = Bukkit.matchPlayer((String)s);
                if (ps.size() == 1) {
                    return (Player)ps.get(0);
                }
                return null;
            }

            @Override
            public String toString(Player p) {
                return p.getDisplayName();
            }

            @Override
            public String getDebugMessage(Player p) {
                return String.valueOf(p.getName()) + " " + Skript.getDebugMessage(p.getLocation());
            }
        }, "player"));
        Skript.registerClass(new ClassInfo<OfflinePlayer>("player", "offlineplayer", OfflinePlayer.class, new EventValueVariable<OfflinePlayer>(OfflinePlayer.class), new Parser<OfflinePlayer>(){

            @Override
            public OfflinePlayer parse(String s) {
                return null;
            }

            @Override
            public String toString(OfflinePlayer p) {
                return p.getName();
            }

            @Override
            public String getDebugMessage(OfflinePlayer p) {
                if (p.isOnline()) {
                    return Skript.getDebugMessage(p.getPlayer());
                }
                return p.getName();
            }
        }, new String[0]));
        Skript.registerClass(new ClassInfo<CommandSender>("player/console", "commandsender", CommandSender.class, new EventValueVariable<CommandSender>(CommandSender.class), new Parser<CommandSender>(){

            @Override
            public CommandSender parse(String s) {
                if (s.equalsIgnoreCase("console") || s.equalsIgnoreCase("server")) {
                    return Bukkit.getConsoleSender();
                }
                return null;
            }

            @Override
            public String toString(CommandSender s) {
                if (s instanceof Player) {
                    return ((Player)s).getDisplayName();
                }
                return s.getName();
            }

            @Override
            public String getDebugMessage(CommandSender s) {
                if (s instanceof Player) {
                    return null;
                }
                return s.getName();
            }
        }, new String[0]));
        Skript.registerClass(new ClassInfo<BlockFace>("direction", "blockface", BlockFace.class, null, new Parser<BlockFace>(){

            @Override
            public BlockFace parse(String s) {
                return Utils.getBlockFace(s, true);
            }

            @Override
            public String toString(BlockFace o) {
                return o.toString().toLowerCase(Locale.ENGLISH).replace('_', ' ');
            }
        }, "direction"));
        Skript.registerClass(new ClassInfo<InventoryHolder>("inventoryholder", InventoryHolder.class, new EventValueVariable<InventoryHolder>(InventoryHolder.class), null));
        Skript.registerClass(new ClassInfo<GameMode>("game mode", "gamemode", GameMode.class, new SimpleLiteral<GameMode>(GameMode.SURVIVAL, true), new Parser<GameMode>(){

            @Override
            public GameMode parse(String s) {
                try {
                    return GameMode.valueOf((String)s.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }

            @Override
            public String toString(GameMode m) {
                return m.toString().toLowerCase();
            }
        }, "game ?mode"));
        Skript.registerClass(new ClassInfo<ItemStack>("material", "itemstack", ItemStack.class, null, new Parser<ItemStack>(){

            @Override
            public ItemStack parse(String s) {
                ItemType t = Aliases.parseItemType(s);
                if (t == null) {
                    return null;
                }
                if ((t = t.getItem()).numTypes() != 1) {
                    Skript.error("'" + s + "' represents multiple materials");
                    return null;
                }
                if (!t.getTypes().get(0).hasDataRange()) {
                    return t.getRandom();
                }
                if (t.getTypes().get((int)0).dataMin > 0) {
                    Skript.error("'" + s + "' represents multiple materials");
                    return null;
                }
                ItemStack i = t.getRandom();
                i.setDurability((short)0);
                return i;
            }

            @Override
            public String toString(ItemStack i) {
                return ItemType.toString(i);
            }
        }, "item", "material"));
    }
}

