/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.WeatherType;
import ch.njol.util.Checker;
import org.bukkit.World;
import org.bukkit.event.Event;

public class CondWeather
extends Condition {
    private Variable<WeatherType> weathers;
    private Variable<World> worlds;

    static {
        Skript.registerCondition(CondWeather.class, "is %weathertypes% [in %worlds%]");
    }

    @Override
    public boolean init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        this.weathers = vars[0];
        this.worlds = vars[1];
        return true;
    }

    @Override
    public boolean run(final Event e) {
        return this.weathers.check(e, new Checker<WeatherType>(){

            @Override
            public boolean check(final WeatherType wt) {
                return CondWeather.this.worlds.check(e, new Checker<World>(){

                    @Override
                    public boolean check(World w) {
                        return wt.isWeather(w);
                    }
                });
            }
        }, this);
    }

    @Override
    public String getDebugMessage(Event e) {
        return "is " + this.weathers.getDebugMessage(e) + " in " + this.worlds.getDebugMessage(e);
    }
}

