/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.api.Comparator;
import ch.njol.skript.api.Condition;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Checker;
import org.bukkit.event.Event;

public class CondIs
extends Condition {
    private static final Patterns<Object> patterns = new Patterns(new Object[][]{{"%objects% ((is|are) (greater|more|higher|bigger) than|\\>) %objects%", Comparator.Relation.GREATER}, {"%objects% ((is|are) (greater|more|higher|bigger) or equal to|(is not|are not|isn't|aren't) (less|smaller) than|\\>=) %objects%", Comparator.Relation.GREATER_OR_EQUAL}, {"%objects% ((is|are) (less|smaller) than|\\<) %objects%", Comparator.Relation.SMALLER}, {"%objects% ((is|are) (less|smaller) or equal to|(is not|are not|isn't|aren't) (greater|more|higher|bigger) than|\\<=) %objects%", Comparator.Relation.SMALLER_OR_EQUAL}, {"%objects% ((is|are) (not|neither)|isn't|aren't|!=) [equal to] %objects%", Comparator.Relation.NOT_EQUAL}, {"%objects% (is|are|=) [equal to] %objects%", Comparator.Relation.EQUAL}, {"%objects% (is|are) between %objects% and %objects%", true}, {"%objects% (is not|are not|isn't|aren't) between %objects% and %objects%", false}, {"%objects@-1% (was|were) (greater|more|higher|bigger) than %objects%", Comparator.Relation.GREATER}, {"%objects@-1% ((was|were) (greater|more|higher|bigger) or equal to|(was not|were not|wasn't|weren't) (less|smaller) than) %objects%", Comparator.Relation.GREATER_OR_EQUAL}, {"%objects@-1% (was|were) (less|smaller) than %objects%", Comparator.Relation.SMALLER}, {"%objects@-1% ((was|were) (less|smaller) or equal to|(was not|were not|wasn't|weren't) (greater|more|higher|bigger) than) %objects%", Comparator.Relation.SMALLER_OR_EQUAL}, {"%objects@-1% ((was|were) (not|neither)|wasn't|weren't) [equal to] %objects%", Comparator.Relation.NOT_EQUAL}, {"%objects@-1% (was|were) [equal to] %objects%", Comparator.Relation.EQUAL}, {"%objects@-1% (was|were) between %objects% and %objects%", true}, {"%objects@-1% (was not|were not|wasn't|weren't) between %objects% and %objects%", false}, {"%objects@1% will be (greater|more|higher|bigger) than %objects%", Comparator.Relation.GREATER}, {"%objects@1% (will be (greater|more|higher|bigger) or equal to|(will not|won't) be (less|smaller) than) %objects%", Comparator.Relation.GREATER_OR_EQUAL}, {"%objects@1% will be (less|smaller) than %objects%", Comparator.Relation.SMALLER}, {"%objects@1% (will be (less|smaller) or equal to|(will not|won't) be (greater|more|higher|bigger) than) %objects%", Comparator.Relation.SMALLER_OR_EQUAL}, {"%objects@1% ((will (not|neither) be|won't be)|(isn't|aren't|is not|are not) (turning|changing) [in]to) [equal to] %objects%", Comparator.Relation.NOT_EQUAL}, {"%objects@1% (will be [equal to]|(is|are) (turning|changing) [in]to) %objects%", Comparator.Relation.EQUAL}, {"%objects@1% will be between %objects% and %objects%", true}, {"%objects@1% (will not be|won't be) between %objects% and %objects%", false}});
    private Variable<?> first;
    private Variable<?> second;
    private Variable<?> third;
    private Comparator.Relation relation;
    private Comparator<?, ?> comp;
    private boolean reverseOrder = false;

    static {
        Skript.registerCondition(CondIs.class, patterns.getPatterns());
    }

    @Override
    public boolean init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) {
        boolean b;
        this.first = vars[0];
        this.second = vars[1];
        this.relation = null;
        Object r = patterns.getInfo(matchedPattern);
        if (r instanceof Comparator.Relation) {
            this.relation = (Comparator.Relation)((Object)r);
            if (this.relation == Comparator.Relation.NOT_EQUAL) {
                this.relation = Comparator.Relation.EQUAL;
                this.setNegated(true);
            }
        } else {
            this.third = vars[2];
            this.relation = Comparator.Relation.get((Boolean)r);
        }
        if (!(b = this.init())) {
            if (Skript.debug()) {
                Skript.info("Can't compare " + this.first.getDebugMessage(null) + " with " + this.second.getDebugMessage(null) + (this.third == null ? "" : " and " + this.third.getDebugMessage(null)));
            }
            if (this.first instanceof UnparsedLiteral || this.second instanceof UnparsedLiteral || this.third instanceof UnparsedLiteral) {
                return false;
            }
            if (this.third == null) {
                Skript.error(this.first + " and " + this.second + " can't be compared");
            } else {
                Skript.error(this.first + " can't be compared with " + this.second + " and/or " + this.third);
            }
            return false;
        }
        if (this.third == null) {
            if (!this.relation.isEqualOrInverse() && !this.comp.supportsOrdering()) {
                Skript.error("The given objects can't be compared with '" + (Object)((Object)this.relation) + "'");
                return false;
            }
        } else if (!this.comp.supportsOrdering()) {
            Skript.error("The given objects can't be checked for being 'in between'");
            return false;
        }
        return true;
    }

    private boolean init() {
        int c;
        int n;
        int n2;
        int[] nArray;
        Class<?> f = this.first.getReturnType();
        Class<?> s = this.second.getReturnType();
        Class<?> t = this.third == null ? null : this.third.getReturnType();
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        int[] zeroOne = nArray2;
        for (Comparator.ComparatorInfo<?, ?> info : Skript.getComparators()) {
            if ((!info.c1.isAssignableFrom(f) || !info.c2.isAssignableFrom(s) || this.third != null && !info.c2.isAssignableFrom(t)) && (!info.c1.isAssignableFrom(s) || this.third != null && !info.c1.isAssignableFrom(t) || !info.c2.isAssignableFrom(f))) continue;
            this.comp = info.c;
            this.reverseOrder = !info.c1.isAssignableFrom(f) || !info.c2.isAssignableFrom(s) || this.third != null && !info.c2.isAssignableFrom(t);
            return true;
        }
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        for (Comparator.ComparatorInfo<?, ?> info : Skript.getComparators()) {
            nArray = zeroOne;
            n2 = zeroOne.length;
            n = 0;
            while (n < n2) {
                c = nArray[n];
                if (info.getType(c).isAssignableFrom(f)) {
                    Variable<?> temp2;
                    Variable<?> temp1 = this.second.getConvertedVariable(info.getType(1 - c));
                    Variable<?> variable = temp2 = this.third == null ? null : this.third.getConvertedVariable(info.getType(1 - c));
                    if (temp1 != null && (this.third == null || temp2 != null)) {
                        this.reverseOrder = c == 1;
                        this.comp = info.c;
                        this.second = temp1;
                        this.third = temp2;
                        SkriptLogger.stopSubLog(log);
                        log.printLog();
                        return true;
                    }
                    log.clear();
                }
                if (info.getType(c).isAssignableFrom(s) && (this.third == null || info.getType(c).isAssignableFrom(t))) {
                    Variable<?> temp = this.first.getConvertedVariable(info.getType(1 - c));
                    if (temp != null) {
                        this.reverseOrder = c == 0;
                        this.comp = info.c;
                        this.first = temp;
                        SkriptLogger.stopSubLog(log);
                        log.printLog();
                        return true;
                    }
                    log.clear();
                }
                ++n;
            }
        }
        for (Comparator.ComparatorInfo<?, ?> info : Skript.getComparators()) {
            nArray = zeroOne;
            n2 = zeroOne.length;
            n = 0;
            while (n < n2) {
                Variable<?> v3;
                c = nArray[n];
                Variable<?> v1 = this.first.getConvertedVariable(info.getType(c));
                Variable<?> v2 = this.second.getConvertedVariable(info.getType(1 - c));
                Variable<?> variable = v3 = this.third == null ? null : this.third.getConvertedVariable(info.getType(1 - c));
                if (v1 != null && v2 != null && (this.third == null || v3 != null)) {
                    this.first = v1;
                    this.second = v2;
                    this.third = v3;
                    this.reverseOrder = c == 1;
                    this.comp = info.c;
                    SkriptLogger.stopSubLog(log);
                    log.printLog();
                    return true;
                }
                log.clear();
                ++n;
            }
        }
        SkriptLogger.stopSubLog(log);
        return false;
    }

    @Override
    public boolean run(final Event e) {
        return this.first.check(e, new Checker<Object>(){

            @Override
            public boolean check(final Object o1) {
                return CondIs.this.second.check(e, new Checker<Object>(){

                    @Override
                    public boolean check(final Object o2) {
                        if (CondIs.this.third == null) {
                            return CondIs.this.relation.is(CondIs.this.compare(o1, o2));
                        }
                        return CondIs.this.third.check(e, new Checker<Object>(){

                            @Override
                            public boolean check(Object o3) {
                                return CondIs.this.relation == Comparator.Relation.NOT_EQUAL ^ (Comparator.Relation.GREATER_OR_EQUAL.is(CondIs.this.compare(o1, o2)) && Comparator.Relation.SMALLER_OR_EQUAL.is(CondIs.this.compare(o1, o3)));
                            }
                        });
                    }
                });
            }
        }, this);
    }

    private <T1, T2> Comparator.Relation compare(T1 o1, T2 o2) {
        return this.reverseOrder ? this.comp.compare(o2, o1).getSwitched() : this.comp.compare(o1, o2);
    }

    @Override
    public String getDebugMessage(Event e) {
        if (this.third == null) {
            return String.valueOf(this.first.getDebugMessage(e)) + " is " + (Object)((Object)(this.isNegated() ? this.relation.getInverse() : this.relation)) + " " + this.second.getDebugMessage(e);
        }
        return String.valueOf(this.first.getDebugMessage(e)) + " is" + (this.relation == Comparator.Relation.EQUAL ? "" : " not") + " between " + this.second.getDebugMessage(e) + " and " + this.third.getDebugMessage(e);
    }
}

