/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.Skript;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.SkriptCommand;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Commands {
    private static final SectionValidator commandStructure = new SectionValidator().addEntry("usage", true).addEntry("description", true).addEntry("permission", true).addEntry("permission message", true).addEntry("aliases", true).addSection("trigger", false);
    public static List<Argument<?>> currentArguments = null;

    public static final boolean loadCommand(SectionNode node) {
        String s = node.getName();
        if (Skript.commandMap == null) {
            Skript.error("CraftBukkit is required to create new commands");
            return false;
        }
        String argPattern = "<([a-zA-Z -]+?)\\s*(=\\s*([^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?))?>";
        Matcher m = Pattern.compile("(?i)^command /?(\\S+)(,? <([a-zA-Z -]+?)\\s*(=\\s*([^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?))?>)*$").matcher(s);
        if (!m.matches()) {
            Skript.error("invalid command layout. It should look like '/command <arg 1>, <arg 2>, ...'");
            return false;
        }
        String command = m.group(1);
        currentArguments = new ArrayList();
        m = Pattern.compile("<([a-zA-Z -]+?)\\s*(=\\s*([^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?))?>").matcher(s);
        boolean hadNonSingle = false;
        int i = 0;
        while (m.find()) {
            Class c;
            if (hadNonSingle) {
                Skript.error("All arguments must be singular except for the last one");
                return false;
            }
            if (m.group(1).equalsIgnoreCase("text")) {
                c = String.class;
                hadNonSingle = true;
            } else {
                c = Skript.getClassFromUserInput(m.group(1));
                Pair<String, Boolean> p = Utils.getPlural(m.group(1));
                if (c == null) {
                    c = Skript.getClassFromUserInput((String)p.first);
                }
                if (((Boolean)p.second).booleanValue()) {
                    hadNonSingle = true;
                }
                if (c == null) {
                    Skript.error("unknown type '" + (String)p.first + "'");
                    return false;
                }
            }
            Argument<String> arg = Argument.newInstance(c, m.group(3), i, !hadNonSingle);
            if (arg == null) {
                return false;
            }
            currentArguments.add(arg);
            ++i;
        }
        node.convertToEntries(0);
        commandStructure.validate(node);
        if (!(node.get("trigger") instanceof SectionNode)) {
            return false;
        }
        String desc = "/" + command + " " + Utils.join(currentArguments);
        String usage = node.get("usage", desc);
        String description = node.get("description", "");
        List<String> aliases = Arrays.asList(node.get("aliases", "").split("\\s*,\\s*/?"));
        if (aliases.get(0).startsWith("/")) {
            aliases.set(0, aliases.get(0).substring(1));
        } else if (aliases.get(0).isEmpty()) {
            aliases = new ArrayList<String>(0);
        }
        String permission = node.get("permission", null);
        String permissionMessage = node.get("permission message", null);
        SectionNode trigger = (SectionNode)node.get("trigger");
        if (trigger == null) {
            Skript.error("A command must always have a 'trigger:' section where all effects & conditions are put");
            return false;
        }
        if (permissionMessage != null && permission == null) {
            Skript.warning("command /" + command + " has a permission message set, but not a permission.");
        }
        if (Skript.debug()) {
            Skript.info("command " + desc + ":");
        }
        Skript.registerCommand(new SkriptCommand(command, currentArguments, description, usage, aliases, permission, permissionMessage, TriggerFileLoader.loadItems(trigger)));
        if (Skript.logVeryHigh() && !Skript.debug()) {
            Skript.info("registered command /" + command);
        }
        currentArguments = null;
        return true;
    }
}

