/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.api.intern;

import ch.njol.skript.Skript;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.intern.Trigger;
import ch.njol.skript.api.intern.TriggerItem;
import ch.njol.skript.config.SectionNode;
import java.util.List;
import org.bukkit.event.Event;

public abstract class TriggerSection
extends TriggerItem {
    private final List<TriggerItem> items;
    private boolean stopped = false;
    private static final String indent = "  ";
    private static String indentation = "  ";

    protected static void incIndentation() {
        indentation = String.valueOf(indentation) + indent;
    }

    protected static void decIndentation() {
        indentation = indentation.substring(indentation.length() - indent.length());
    }

    protected TriggerSection(List<TriggerItem> items) {
        this.items = items;
        for (TriggerItem item : items) {
            item.setParent(this);
        }
    }

    protected TriggerSection(SectionNode node) {
        TriggerFileLoader.currentSections.add(this);
        this.items = TriggerFileLoader.loadItems(node);
        for (TriggerItem item : this.items) {
            item.setParent(this);
        }
        TriggerFileLoader.currentSections.remove(TriggerFileLoader.currentSections.size() - 1);
    }

    @Override
    public abstract boolean run(Event var1);

    protected void run(Event e, boolean run) {
        if (Skript.debug() && !(this instanceof Trigger)) {
            Skript.info(String.valueOf(indentation) + (run ? "" : "-") + this.getDebugMessage(e) + ":");
        }
        if (!run) {
            return;
        }
        this.stopped = false;
        if (Skript.debug() && !(this instanceof Trigger)) {
            TriggerSection.incIndentation();
        }
        for (TriggerItem i : this.items) {
            boolean ok = i.run(e);
            if (Skript.debug() && !(i instanceof TriggerSection)) {
                if (!this.stopped) {
                    Skript.info(String.valueOf(indentation) + (ok ? "" : "-") + i.getDebugMessage(e));
                } else {
                    Skript.info(String.valueOf(indentation) + "#" + i.getDebugMessage(e));
                }
            }
            if (this.stopped || !ok) break;
        }
        if (Skript.debug() && !(this instanceof Trigger)) {
            TriggerSection.decIndentation();
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

