/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.api.intern;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.intern.ChainedConverter;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.Variable;
import ch.njol.util.Checker;
import org.bukkit.event.Event;

public class ConvertedVariable<F, T>
implements Variable<T> {
    protected Variable<? extends F> source;
    protected Class<T> to;
    private final Converter<? super F, ? extends T> conv;

    public ConvertedVariable(Variable<? extends F> source, Class<T> to, Converter<? super F, ? extends T> conv) {
        this.source = source;
        this.to = to;
        this.conv = conv;
    }

    public static <F, T> ConvertedVariable<F, T> newInstance(Variable<F> v, Class<T> to) {
        if (v == null || to == null || to.isAssignableFrom(v.getReturnType())) {
            return null;
        }
        return ConvertedVariable.newInstance(v, v.getReturnType(), to);
    }

    private static <F, T> ConvertedVariable<F, T> newInstance(Variable<F> v, Class<? extends F> from, final Class<T> to) {
        if (from.isAssignableFrom(to)) {
            return new ConvertedVariable<F, T>(v, to, new Converter<F, T>(){

                @Override
                public T convert(F f) {
                    if (to.isInstance(f)) {
                        return f;
                    }
                    return null;
                }
            });
        }
        Converter<? extends F, T> c = Skript.getConverter(from, to);
        if (c == null) {
            return null;
        }
        return new ConvertedVariable<F, T>(v, to, c);
    }

    @Override
    public final boolean init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult matcher) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "{" + this.source.getDebugMessage(e) + "}->" + this.to.getName();
        }
        return this.source.getDebugMessage(e);
    }

    @Override
    public String toString() {
        return this.source.toString();
    }

    @Override
    public Class<T> getReturnType() {
        return this.to;
    }

    @Override
    public boolean isSingle() {
        return this.source.isSingle();
    }

    @Override
    public <R> Variable<? extends R> getConvertedVariable(Class<R> to) {
        if (to.isAssignableFrom(this.to)) {
            return this;
        }
        return this.source.getConvertedVariable(to);
    }

    @Override
    public void setAnd(boolean and) {
        this.source.setAnd(and);
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return this.source.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        this.source.change(e, delta, mode);
    }

    @Override
    public T getSingle(Event e) {
        F f = this.source.getSingle(e);
        if (f == null) {
            return null;
        }
        return this.conv.convert(f);
    }

    @Override
    public T[] getArray(Event e) {
        return this.source.getArray(e, this.to, this.conv);
    }

    @Override
    public <V> V getSingle(Event e, Converter<? super T, ? extends V> converter) {
        T t = this.getSingle(e);
        if (t == null) {
            return null;
        }
        return converter.convert(t);
    }

    @Override
    public <V> V[] getArray(Event e, Class<V> to, Converter<? super T, ? extends V> converter) {
        return this.source.getArray(e, to, new ChainedConverter<F, T, V>(this.conv, converter));
    }

    @Override
    public boolean check(Event e, final Checker<? super T> c, Condition cond) {
        return this.source.check(e, new Checker<F>(){

            @Override
            public boolean check(F f) {
                Object t = ConvertedVariable.this.conv.convert(f);
                if (t == null) {
                    return false;
                }
                return c.check(t);
            }
        }, cond);
    }

    @Override
    public boolean check(Event e, final Checker<? super T> c) {
        return this.source.check(e, new Checker<F>(){

            @Override
            public boolean check(F f) {
                Object t = ConvertedVariable.this.conv.convert(f);
                if (t == null) {
                    return false;
                }
                return c.check(t);
            }
        });
    }

    @Override
    public boolean getAnd() {
        return this.source.getAnd();
    }

    @Override
    public boolean setTime(int time) {
        return this.source.setTime(time);
    }

    @Override
    public int getTime() {
        return this.source.getTime();
    }

    @Override
    public boolean isDefault() {
        return this.source.isDefault();
    }
}

