/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.api.intern.Conditional;
import ch.njol.skript.api.intern.Loop;
import ch.njol.skript.api.intern.TopLevelExpression;
import ch.njol.skript.api.intern.Trigger;
import ch.njol.skript.api.intern.TriggerItem;
import ch.njol.skript.api.intern.TriggerSection;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.Commands;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Callback;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.bukkit.event.Event;

public final class TriggerFileLoader {
    public static SkriptEvent currentEvent = null;
    public static Class<? extends Event>[] currentEvents = null;
    public static List<TriggerSection> currentSections = new ArrayList<TriggerSection>();
    public static List<LoopVar<?>> currentLoops = new ArrayList();
    public static final Map<String, ItemType> currentAliases = new HashMap<String, ItemType>();
    public static final HashMap<String, String> options = new HashMap();
    static int loadedTriggers = 0;
    static int loadedCommands = 0;
    private static String indentation = "";

    private TriggerFileLoader() {
    }

    private static final String replaceOptions(String s) {
        return StringUtils.replaceAll(s, "\\{(.+?)\\}", new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                String option = options.get(m.group(1));
                if (option == null) {
                    Skript.error("undefined option " + m.group());
                    return null;
                }
                return option;
            }
        });
    }

    public static ArrayList<TriggerItem> loadItems(SectionNode node) {
        if (Skript.debug()) {
            indentation = String.valueOf(indentation) + "    ";
        }
        ArrayList<TriggerItem> items = new ArrayList<TriggerItem>();
        for (Node n : node) {
            Condition cond;
            SkriptLogger.setNode(n);
            if (n instanceof SimpleNode) {
                TopLevelExpression expr;
                SimpleNode e = (SimpleNode)n;
                String ex = TriggerFileLoader.replaceOptions(e.getName());
                if (ex == null || (expr = TopLevelExpression.parse(ex, "can't understand this condition/effect: '" + ex + "'")) == null) continue;
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + expr.getDebugMessage(null));
                }
                items.add(expr);
                continue;
            }
            if (!(n instanceof SectionNode)) continue;
            if (n.getName().startsWith("loop ")) {
                LoopVar loopvar;
                String l = TriggerFileLoader.replaceOptions(n.getName().substring("loop ".length()));
                if (l == null || (loopvar = (LoopVar)ExprParser.parse(l, Skript.loops.listIterator(), false, "can't understand this loop: '" + n.getName() + "'")) == null) continue;
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + "loop " + loopvar.getLoopDebugMessage(null) + ":");
                }
                currentLoops.add(loopvar);
                Loop loop = new Loop(loopvar, (SectionNode)n);
                currentLoops.remove(currentLoops.size() - 1);
                items.add(loop);
                continue;
            }
            if (n.getName().equalsIgnoreCase("else")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional)) {
                    Skript.error("'else' has to be placed just after the end of a conditional section");
                    continue;
                }
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + "else:");
                }
                ((Conditional)items.get(items.size() - 1)).loadElseClause((SectionNode)n);
                continue;
            }
            String name = n.getName();
            if (name.startsWith("if ")) {
                name = name.substring(3);
            }
            if ((cond = Condition.parse(name, "can't understand this condition: '" + name + "'")) == null) continue;
            if (Skript.debug()) {
                Skript.info(String.valueOf(indentation) + cond.getDebugMessage(null) + ":");
            }
            items.add(new Conditional(cond, (SectionNode)n));
        }
        SkriptLogger.setNode(node);
        if (Skript.debug()) {
            indentation = indentation.substring(0, indentation.length() - 4);
        }
        return items;
    }

    static void load(Config config) {
        int numTriggers = 0;
        int numCommands = 0;
        currentAliases.clear();
        options.clear();
        for (Node cnode : config.getMainNode()) {
            Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parsedEvent;
            if (!(cnode instanceof SectionNode)) {
                Skript.error("invalid line in trigger file");
                continue;
            }
            SectionNode node = (SectionNode)cnode;
            String event = node.getName();
            if (event.equalsIgnoreCase("aliases")) {
                node.convertToEntries(0, "=");
                for (Node n : node) {
                    if (!(n instanceof EntryNode)) {
                        Skript.error("invalid line in alias section");
                        continue;
                    }
                    ItemType t = Aliases.parseAlias(((EntryNode)n).getValue());
                    if (t == null) continue;
                    currentAliases.put(((EntryNode)n).getKey().toLowerCase(Locale.ENGLISH), t);
                }
                continue;
            }
            if (event.equalsIgnoreCase("options")) {
                node.convertToEntries(0);
                for (Node n : node) {
                    if (!(n instanceof EntryNode)) {
                        Skript.error("invalid line in options");
                        continue;
                    }
                    options.put(((EntryNode)n).getKey(), ((EntryNode)n).getValue());
                }
                continue;
            }
            if (StringUtils.count(event, '\"') % 2 != 0) {
                Skript.error("Invalid use of quotes (\"). If you want to use quotes in \"quoted text\", double them: \"\".");
                continue;
            }
            if (event.toLowerCase().startsWith("command ")) {
                currentEvent = null;
                currentEvents = Skript.array(CommandEvent.class);
                if (!Commands.loadCommand(node)) continue;
                ++numCommands;
                continue;
            }
            if (Skript.logVeryHigh() && !Skript.debug()) {
                Skript.info("loading trigger '" + event + "'");
            }
            if (event.toLowerCase().startsWith("on ")) {
                event = event.substring("on ".length());
            }
            if ((event = TriggerFileLoader.replaceOptions(event)) == null || (parsedEvent = ExprParser.parseEvent(event, "can't understand this event: '" + node.getName() + "'")) == null) continue;
            if (Skript.debug()) {
                Skript.info(String.valueOf(event) + " (" + ((SkriptEvent)parsedEvent.second).getDebugMessage(null) + "):");
            }
            currentEvent = (SkriptEvent)parsedEvent.second;
            currentEvents = ((SkriptEvent.SkriptEventInfo)parsedEvent.first).events;
            Trigger trigger = new Trigger(event, (SkriptEvent)parsedEvent.second, TriggerFileLoader.loadItems(node));
            SkriptEventHandler.addTrigger(((SkriptEvent.SkriptEventInfo)parsedEvent.first).events, trigger);
            ++numTriggers;
        }
        if (Skript.logHigh()) {
            Skript.info("loaded " + numTriggers + " trigger" + (numTriggers == 1 ? "" : "s") + " and " + numCommands + " command" + (numCommands == 1 ? "" : "s") + (!Skript.logVeryHigh() ? " from '" + config.getFileName() + "'" : ""));
        }
        loadedCommands += numCommands;
        loadedTriggers += numTriggers;
    }
}

