/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables.base;

import ch.njol.skript.Skript;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.DefaultVariable;
import ch.njol.skript.api.Getter;
import ch.njol.skript.api.exception.ParseException;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;

public class EventValueVariable<T>
extends SimpleVariable<T>
implements DefaultVariable<T> {
    private final Class<T> c;
    private final T[] one;
    private final Changer<T> changer;
    private final Map<Class<? extends Event>, Getter<? extends T, ?>> getters = new HashMap();

    public EventValueVariable(Class<T> c) {
        this(c, null);
    }

    public EventValueVariable(Class<T> c, Changer<T> changer) {
        this.c = c;
        this.one = (Object[])Array.newInstance(c, 1);
        this.changer = changer;
    }

    @Override
    protected final T[] getAll(Event e) {
        this.one[0] = this.getValue(e);
        if (this.one[0] == null) {
            return null;
        }
        return this.one;
    }

    private <E extends Event> T getValue(E e) {
        Getter<T, ?> g = this.getters.get(e.getClass());
        if (g != null) {
            return g.get(e);
        }
        for (Map.Entry<Class<Event>, Getter<T, ?>> p : this.getters.entrySet()) {
            if (!p.getKey().isAssignableFrom(e.getClass())) continue;
            return p.getValue().get(e);
        }
        return null;
    }

    @Override
    public final void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) throws ParseException {
        this.init();
    }

    @Override
    public void init() throws ParseException {
        boolean hasValue = false;
        Class<? extends Event>[] classArray = TriggerFileLoader.currentEvents;
        int n = TriggerFileLoader.currentEvents.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> e = classArray[n2];
            if (this.getters.containsKey(e)) {
                hasValue = true;
            } else {
                Getter<T, ? extends Event> getter = Skript.getEventValueGetter(e, this.c);
                if (getter != null) {
                    this.getters.put(e, getter);
                    hasValue = true;
                }
            }
            ++n2;
        }
        if (!hasValue) {
            throw new ParseException("There's no " + Skript.getExactClassName(this.c) + " in this event");
        }
    }

    @Override
    public Class<T> getReturnType() {
        return this.c;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String getDebugMessage(Event e) {
        if (e == null) {
            return "event-" + this.c.getName();
        }
        return Skript.getDebugMessage(this.getValue(e));
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (this.changer == null) {
            return null;
        }
        return this.changer.acceptChange(mode);
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        if (this.changer == null) {
            throw new UnsupportedOperationException();
        }
        this.changer.change(e, this, delta, mode);
    }

    @Override
    public String toString() {
        return "event-" + Skript.getExactClassName(this.c);
    }
}

