/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer;
import ch.njol.skript.api.Getter;
import ch.njol.skript.api.exception.InitException;
import ch.njol.skript.api.exception.ParseException;
import ch.njol.skript.lang.ExprParser;
import ch.njol.skript.lang.SimpleVariable;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.WeatherType;
import org.bukkit.World;
import org.bukkit.event.Event;

public class VarWeather
extends SimpleVariable<WeatherType> {
    private Variable<World> worlds;

    static {
        Skript.registerVariable(VarWeather.class, WeatherType.class, "weather [(in|of) %worlds%]");
    }

    @Override
    public void init(Variable<?>[] vars, int matchedPattern, ExprParser.ParseResult parser) throws InitException, ParseException {
        this.worlds = vars[0];
    }

    @Override
    public String getDebugMessage(Event e) {
        return "weather in " + this.worlds.getDebugMessage(e);
    }

    protected WeatherType[] getAll(Event e) {
        return this.worlds.getArray(e, WeatherType.class, new Getter<WeatherType, World>(){

            @Override
            public WeatherType get(World w) {
                return WeatherType.fromWorld(w);
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.CLEAR || mode == Changer.ChangeMode.SET) {
            return WeatherType.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Variable<?> delta, Changer.ChangeMode mode) {
        switch (mode) {
            case CLEAR: {
                World[] worldArray = this.worlds.getArray(e);
                int n = worldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    World w = worldArray[n2];
                    w.setStorm(false);
                    w.setThundering(false);
                    ++n2;
                }
                break;
            }
            case SET: {
                WeatherType t = (WeatherType)((Object)delta.getSingle(e));
                World[] worldArray = this.worlds.getArray(e);
                int n = worldArray.length;
                int n3 = 0;
                while (n3 < n) {
                    World w = worldArray[n3];
                    t.setWeather(w);
                    ++n3;
                }
                break;
            }
        }
    }

    @Override
    public Class<? extends WeatherType> getReturnType() {
        return WeatherType.class;
    }

    @Override
    public String toString() {
        return "the weather in " + this.worlds;
    }

    @Override
    public boolean isSingle() {
        return this.worlds.isSingle();
    }
}

